
package org.blufin.sdk.filters;
import lombok.Getter;
import lombok.NoArgsConstructor;
import org.blufin.base.helper.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
@NoArgsConstructor
public class FilterContainer {
    @Getter
    Match groupMatch = Match.ALL;
    @Getter
    List<Pair<Match, List<Filter>>> groups = new ArrayList<>();
    public FilterContainer(List<Filter> filters) {
        groups.add(Pair.of(Match.ALL, filters));
    }
    public FilterContainer(Match match, List<Filter> filters) {
        groups.add(Pair.of(match, filters));
    }
    public FilterContainer(Match match, Filter filter) {
        groups.add(Pair.of(match, Collections.singletonList(filter)));
    }
    public FilterContainer(Match match) {
        this.groupMatch = match;
    }
    public void addGroup(Pair<Match, List<Filter>> group) {
        groups.add(group);
    }
}
