
package org.blufin.sdk.filters;
import org.blufin.sdk.constants.SdkConstants;
import java.util.List;
public class FilterUriBuilder {
    public static final String build(List<Filter> filters) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SdkConstants.FILTERS).append("=[");
        for (Filter filter : filters) {
            stringBuilder
                    .append("[\"")
                    .append(filter.getFieldName())
                    .append("\",\"")
                    .append(filter.getModifier().toString())
                    .append("\",\"")
                    .append(filter.getPrimaryValue().replaceAll("\"", "\\\""));
            if (filter.getModifier().equals(Modifier.BETWEEN) || filter.getModifier().equals(Modifier.BETWEEN_OR_EQUAL)) {
                stringBuilder
                        .append("\",\"")
                        .append(filter.getSecondaryValue().replaceAll("\"", "\\\""));
            }
            stringBuilder.append("\"],");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}
