
package org.blufin.sdk.filters;
import lombok.Getter;
import java.util.HashMap;
import java.util.Map;
public enum Modifier {
    EQUALS("="),
    NOT_EQUALS("!="),
    GREATER(">"),
    GREATER_OR_EQUAL(">="),
    LESS("<"),
    LESS_OR_EQUAL("<="),
    BETWEEN("><"),
    BETWEEN_OR_EQUAL("=><="),
    CONTAINS("%"),
    NOT_CONTAINS("!%"),
    STARTS_WITH("^%"),
    NOT_STARTS_WITH("!^%"),
    ENDS_WITH("%^"),
    NOT_ENDS_WITH("!%^");
    private static Map<String, Modifier> map = new HashMap<>();
    @Getter
    private final String symbol;
    static {
        for (Modifier modifier : Modifier.values()) {
            map.put(modifier.getSymbol(), modifier);
        }
    }
    Modifier(String symbol) {
        this.symbol = symbol;
    }
    public static final Modifier get(String symbol) {
        return map.get(symbol);
    }
    @Override
    public String toString() {
        return this.symbol;
    }
}
