
package org.blufin.sdk.filters;
import org.blufin.base.helper.Pair;
import org.blufin.sdk.constants.SdkConstants;
import org.blufin.sdk.enums.SortOrder;
import java.util.List;
public class SortUriBuilder {
    public static final String build(List<Pair<String, SortOrder>> sortList) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SdkConstants.SORT).append("=[");
        for (Pair<String, SortOrder> sort : sortList) {
            stringBuilder
                    .append("[\"")
                    .append(sort.getKey())
                    .append("\",\"")
                    .append(sort.getValue().getName())
                    .append("\"],");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}
