
package org.blufin.sdk.filters.dynamic;
import org.blufin.sdk.base.AbstractFilter;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.FilterType;
import lombok.AccessLevel;
import lombok.Getter;
import java.util.List;
@Getter(AccessLevel.PROTECTED)
public abstract class FilterBase<T> {
    private Filter filter;
    private T originalRequest;
    protected FilterBase(FilterType filterType, AbstractFilter filter, List<Filter> filters, T originalRequest, boolean allowDuplicates) {
        this.filter = new Filter(filterType, filter.getFieldName());
        this.originalRequest = originalRequest;
        if (allowDuplicates == false && alreadyExists(filter, filters)) {
            return;
        }
        filters.add(this.filter);
    }
    private boolean alreadyExists(AbstractFilter filter, List<Filter> filters) {
        for (Filter filterObject : filters) {
            if (filterObject.getFieldName().equals(filter.getFieldName())) {
                return true;
            }
        }
        return false;
    }
}
