
package org.blufin.sdk.filters.dynamic;
import org.blufin.sdk.base.AbstractFilter;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.FilterType;
import org.blufin.sdk.filters.Modifier;
import org.blufin.sdk.filters.interfaces.BooleanFilterable;
import java.util.List;
public class FilterBoolean<T> extends FilterBase<T> implements BooleanFilterable<T> {
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public FilterBoolean(AbstractFilter filter, List<Filter> filters, T originalRequest) {
        super(FilterType.BOOLEAN, filter, filters, originalRequest, false);
    }
    @Override
    public T is(boolean value) {
        getFilter().setModifier(Modifier.EQUALS);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isTrue() {
        getFilter().setModifier(Modifier.EQUALS);
        getFilter().setPrimaryValue(TRUE);
        return getOriginalRequest();
    }
    @Override
    public T isFalse() {
        getFilter().setModifier(Modifier.EQUALS);
        getFilter().setPrimaryValue(FALSE);
        return getOriginalRequest();
    }
}
