
package org.blufin.sdk.filters.dynamic;
import org.blufin.base.utils.UtilsDate;
import org.blufin.sdk.base.AbstractFilter;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.FilterType;
import org.blufin.sdk.filters.Modifier;
import org.blufin.sdk.filters.interfaces.MatchComparisonFilterable;
import java.time.LocalDate;
import java.util.List;
public class FilterDate<T> extends FilterBase<T> implements MatchComparisonFilterable<T, LocalDate> {
    public FilterDate(AbstractFilter filter, List<Filter> filters, T originalRequest) {
        super(FilterType.DATE, filter, filters, originalRequest, true);
    }
    @Override
    public T is(LocalDate value) {
        getFilter().setModifier(Modifier.EQUALS);
        getFilter().setPrimaryValue(UtilsDate.convertLocalDateToString(value));
        return getOriginalRequest();
    }
    @Override
    public T isNot(LocalDate value) {
        getFilter().setModifier(Modifier.NOT_EQUALS);
        getFilter().setPrimaryValue(UtilsDate.convertLocalDateToString(value));
        return getOriginalRequest();
    }
    @Override
    public T isLessThan(LocalDate value) {
        getFilter().setModifier(Modifier.LESS);
        getFilter().setPrimaryValue(UtilsDate.convertLocalDateToString(value));
        return getOriginalRequest();
    }
    @Override
    public T isLessThanOrEqualTo(LocalDate value) {
        getFilter().setModifier(Modifier.LESS_OR_EQUAL);
        getFilter().setPrimaryValue(UtilsDate.convertLocalDateToString(value));
        return getOriginalRequest();
    }
    @Override
    public T isGreaterThan(LocalDate value) {
        getFilter().setModifier(Modifier.GREATER);
        getFilter().setPrimaryValue(UtilsDate.convertLocalDateToString(value));
        return getOriginalRequest();
    }
    @Override
    public T isGreaterThanOrEqualTo(LocalDate value) {
        getFilter().setModifier(Modifier.GREATER_OR_EQUAL);
        getFilter().setPrimaryValue(UtilsDate.convertLocalDateToString(value));
        return getOriginalRequest();
    }
    @Override
    public T isBetween(LocalDate from, LocalDate to) {
        LocalDate[] localDates = earliestToLatest(from, to);
        getFilter().setModifier(Modifier.BETWEEN);
        getFilter().setPrimaryValue(UtilsDate.convertLocalDateToString(localDates[0]));
        getFilter().setSecondaryValue(UtilsDate.convertLocalDateToString(localDates[1]));
        return getOriginalRequest();
    }
    @Override
    public T isBetweenOrEqualTo(LocalDate from, LocalDate to) {
        LocalDate[] localDates = earliestToLatest(from, to);
        getFilter().setModifier(Modifier.BETWEEN_OR_EQUAL);
        getFilter().setPrimaryValue(UtilsDate.convertLocalDateToString(localDates[0]));
        getFilter().setSecondaryValue(UtilsDate.convertLocalDateToString(localDates[1]));
        return getOriginalRequest();
    }
    private LocalDate[] earliestToLatest(LocalDate from, LocalDate to) {
        LocalDate[] localDates = new LocalDate[2];
        localDates[0] = (from.isBefore(to)) ? from : to;
        localDates[1] = (from.isBefore(to)) ? to : from;
        return localDates;
    }
}
