
package org.blufin.sdk.filters.dynamic;
import org.blufin.base.utils.UtilsDate;
import org.blufin.sdk.base.AbstractFilter;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.FilterType;
import org.blufin.sdk.filters.Modifier;
import org.blufin.sdk.filters.interfaces.MatchComparisonFilterable;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
public class FilterDateTime<T> extends FilterBase<T> implements MatchComparisonFilterable<T, ZonedDateTime> {
    public FilterDateTime(AbstractFilter filter, List<Filter> filters, T originalRequest) {
        super(FilterType.DATETIME, filter, filters, originalRequest, true);
    }
    @Override
    public T is(ZonedDateTime value) {
        getFilter().setModifier(Modifier.EQUALS);
        getFilter().setPrimaryValue(UtilsDate.convertZonedDateTimeToString(value));
        return getOriginalRequest();
    }
    @Override
    public T isNot(ZonedDateTime value) {
        getFilter().setModifier(Modifier.NOT_EQUALS);
        getFilter().setPrimaryValue(UtilsDate.convertZonedDateTimeToString(value));
        return getOriginalRequest();
    }
    @Override
    public T isLessThan(ZonedDateTime value) {
        getFilter().setModifier(Modifier.LESS);
        getFilter().setPrimaryValue(UtilsDate.convertZonedDateTimeToString(value));
        return getOriginalRequest();
    }
    @Override
    public T isLessThanOrEqualTo(ZonedDateTime value) {
        getFilter().setModifier(Modifier.LESS_OR_EQUAL);
        getFilter().setPrimaryValue(UtilsDate.convertZonedDateTimeToString(value));
        return getOriginalRequest();
    }
    @Override
    public T isGreaterThan(ZonedDateTime value) {
        getFilter().setModifier(Modifier.GREATER);
        getFilter().setPrimaryValue(UtilsDate.convertZonedDateTimeToString(value));
        return getOriginalRequest();
    }
    @Override
    public T isGreaterThanOrEqualTo(ZonedDateTime value) {
        getFilter().setModifier(Modifier.GREATER_OR_EQUAL);
        getFilter().setPrimaryValue(UtilsDate.convertZonedDateTimeToString(value));
        return getOriginalRequest();
    }
    @Override
    public T isBetween(ZonedDateTime from, ZonedDateTime to) {
        ZonedDateTime[] zonedDateTimes = earliestToLatest(from, to);
        getFilter().setModifier(Modifier.BETWEEN);
        getFilter().setPrimaryValue(UtilsDate.convertZonedDateTimeToString(zonedDateTimes[0]));
        getFilter().setSecondaryValue(UtilsDate.convertZonedDateTimeToString(zonedDateTimes[1]));
        return getOriginalRequest();
    }
    @Override
    public T isBetweenOrEqualTo(ZonedDateTime from, ZonedDateTime to) {
        ZonedDateTime[] zonedDateTimes = earliestToLatest(from, to);
        getFilter().setModifier(Modifier.BETWEEN_OR_EQUAL);
        getFilter().setPrimaryValue(UtilsDate.convertZonedDateTimeToString(zonedDateTimes[0]));
        getFilter().setSecondaryValue(UtilsDate.convertZonedDateTimeToString(zonedDateTimes[1]));
        return getOriginalRequest();
    }
    private ZonedDateTime[] earliestToLatest(ZonedDateTime from, ZonedDateTime to) {
        ZonedDateTime[] zoneDateTimes = new ZonedDateTime[2];
        zoneDateTimes[0] = (ChronoUnit.MINUTES.between(from, to) >= 0) ? from : to;
        zoneDateTimes[1] = (ChronoUnit.MINUTES.between(from, to) >= 0) ? to : from;
        return zoneDateTimes;
    }
}
