
package org.blufin.sdk.filters.dynamic;
import org.blufin.sdk.base.AbstractFilter;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.FilterType;
import org.blufin.sdk.filters.Modifier;
import org.blufin.sdk.filters.interfaces.DecimalFilterable;
import java.math.BigDecimal;
import java.util.List;
public class FilterDecimal<T> extends FilterBase<T> implements DecimalFilterable<T> {
    public FilterDecimal(AbstractFilter filter, List<Filter> filters, T originalRequest) {
        super(FilterType.DECIMAL, filter, filters, originalRequest, true);
    }
    @Override
    public T is(BigDecimal value) {
        getFilter().setModifier(Modifier.EQUALS);
        getFilter().setPrimaryValue(value.toString());
        return getOriginalRequest();
    }
    @Override
    public T isNot(BigDecimal value) {
        getFilter().setModifier(Modifier.NOT_EQUALS);
        getFilter().setPrimaryValue(value.toString());
        return getOriginalRequest();
    }
    @Override
    public T isLessThan(BigDecimal value) {
        getFilter().setModifier(Modifier.LESS);
        getFilter().setPrimaryValue(value.toString());
        return getOriginalRequest();
    }
    @Override
    public T isLessThanOrEqualTo(BigDecimal value) {
        getFilter().setModifier(Modifier.LESS_OR_EQUAL);
        getFilter().setPrimaryValue(value.toString());
        return getOriginalRequest();
    }
    @Override
    public T isGreaterThan(BigDecimal value) {
        getFilter().setModifier(Modifier.GREATER);
        getFilter().setPrimaryValue(value.toString());
        return getOriginalRequest();
    }
    @Override
    public T isGreaterThanOrEqualTo(BigDecimal value) {
        getFilter().setModifier(Modifier.GREATER_OR_EQUAL);
        getFilter().setPrimaryValue(value.toString());
        return getOriginalRequest();
    }
    @Override
    public T isBetween(BigDecimal from, BigDecimal to) {
        BigDecimal[] values = smallestToHighest(from, to);
        getFilter().setModifier(Modifier.BETWEEN);
        getFilter().setPrimaryValue(String.valueOf(values[0]));
        getFilter().setSecondaryValue(String.valueOf(values[1]));
        return getOriginalRequest();
    }
    @Override
    public T isBetweenOrEqualTo(BigDecimal from, BigDecimal to) {
        BigDecimal[] values = smallestToHighest(from, to);
        getFilter().setModifier(Modifier.BETWEEN_OR_EQUAL);
        getFilter().setPrimaryValue(String.valueOf(values[0]));
        getFilter().setSecondaryValue(String.valueOf(values[1]));
        return getOriginalRequest();
    }
    private BigDecimal[] smallestToHighest(BigDecimal from, BigDecimal to) {
        BigDecimal[] values = new BigDecimal[2];
        values[0] = from.compareTo(to) == -1 || from.compareTo(to) == 0 ? from : to;
        values[1] = from.compareTo(to) == -1 || from.compareTo(to) == 0 ? to : from;
        return values;
    }
}
