
package org.blufin.sdk.filters.dynamic;
import org.blufin.sdk.base.AbstractFilter;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.FilterType;
import org.blufin.sdk.filters.Modifier;
import org.blufin.sdk.filters.interfaces.MatchFilterable;
import java.util.List;
public class FilterEnum<T, E extends Enum> extends FilterBase<T> implements MatchFilterable<T, E> {
    public FilterEnum(AbstractFilter filter, List<Filter> filters, T originalRequest) {
        super(FilterType.ENUM, filter, filters, originalRequest, true);
    }
    @Override
    public T is(E value) {
        getFilter().setModifier(Modifier.EQUALS);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isNot(E value) {
        getFilter().setModifier(Modifier.NOT_EQUALS);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
}
