
package org.blufin.sdk.filters.dynamic;
import org.blufin.sdk.base.AbstractFilter;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.FilterType;
import org.blufin.sdk.filters.Modifier;
import org.blufin.sdk.filters.interfaces.IntegerFilterable;
import java.util.List;
public class FilterInteger<T> extends FilterBase<T> implements IntegerFilterable<T> {
    public FilterInteger(AbstractFilter filter, List<Filter> filters, T originalRequest) {
        super(FilterType.INTEGER, filter, filters, originalRequest, true);
    }
    @Override
    public T is(int value) {
        getFilter().setModifier(Modifier.EQUALS);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isNot(int value) {
        getFilter().setModifier(Modifier.NOT_EQUALS);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isLessThan(int value) {
        getFilter().setModifier(Modifier.LESS);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isLessThanOrEqualTo(int value) {
        getFilter().setModifier(Modifier.LESS_OR_EQUAL);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isGreaterThan(int value) {
        getFilter().setModifier(Modifier.GREATER);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isGreaterThanOrEqualTo(int value) {
        getFilter().setModifier(Modifier.GREATER_OR_EQUAL);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isBetween(int from, int to) {
        int[] values = smallestToHighest(from, to);
        getFilter().setModifier(Modifier.BETWEEN);
        getFilter().setPrimaryValue(String.valueOf(values[0]));
        getFilter().setSecondaryValue(String.valueOf(values[1]));
        return getOriginalRequest();
    }
    @Override
    public T isBetweenOrEqualTo(int from, int to) {
        int[] values = smallestToHighest(from, to);
        getFilter().setModifier(Modifier.BETWEEN_OR_EQUAL);
        getFilter().setPrimaryValue(String.valueOf(values[0]));
        getFilter().setSecondaryValue(String.valueOf(values[1]));
        return getOriginalRequest();
    }
    private int[] smallestToHighest(int from, int to) {
        int[] values = new int[2];
        values[0] = (from <= to) ? from : to;
        values[1] = (from <= to) ? to : from;
        return values;
    }
}
