
package org.blufin.sdk.filters.dynamic;
import org.blufin.sdk.base.AbstractFilter;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.FilterType;
import org.blufin.sdk.filters.Modifier;
import org.blufin.sdk.filters.interfaces.IntegerBigFilterable;
import java.util.List;
public class FilterIntegerBig<T> extends FilterBase<T> implements IntegerBigFilterable<T> {
    public FilterIntegerBig(AbstractFilter filter, List<Filter> filters, T originalRequest) {
        super(FilterType.INTEGER_BIG, filter, filters, originalRequest, true);
    }
    @Override
    public T is(long value) {
        getFilter().setModifier(Modifier.EQUALS);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isNot(long value) {
        getFilter().setModifier(Modifier.NOT_EQUALS);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isLessThan(long value) {
        getFilter().setModifier(Modifier.LESS);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isLessThanOrEqualTo(long value) {
        getFilter().setModifier(Modifier.LESS_OR_EQUAL);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isGreaterThan(long value) {
        getFilter().setModifier(Modifier.GREATER);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isGreaterThanOrEqualTo(long value) {
        getFilter().setModifier(Modifier.GREATER_OR_EQUAL);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isBetween(long from, long to) {
        long[] values = smallestToHighest(from, to);
        getFilter().setModifier(Modifier.BETWEEN);
        getFilter().setPrimaryValue(String.valueOf(values[0]));
        getFilter().setSecondaryValue(String.valueOf(values[1]));
        return getOriginalRequest();
    }
    @Override
    public T isBetweenOrEqualTo(long from, long to) {
        long[] values = smallestToHighest(from, to);
        getFilter().setModifier(Modifier.BETWEEN_OR_EQUAL);
        getFilter().setPrimaryValue(String.valueOf(values[0]));
        getFilter().setSecondaryValue(String.valueOf(values[1]));
        return getOriginalRequest();
    }
    private long[] smallestToHighest(long from, long to) {
        long[] values = new long[2];
        values[0] = (from <= to) ? from : to;
        values[1] = (from <= to) ? to : from;
        return values;
    }
}
