
package org.blufin.sdk.filters.dynamic;
import org.blufin.sdk.base.AbstractFilter;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.FilterType;
import org.blufin.sdk.filters.Modifier;
import org.blufin.sdk.filters.interfaces.IntegerSmallFilterable;
import java.util.List;
public class FilterIntegerSmall<T> extends FilterBase<T> implements IntegerSmallFilterable<T> {
    public FilterIntegerSmall(AbstractFilter filter, List<Filter> filters, T originalRequest) {
        super(FilterType.INTEGER_SMALL, filter, filters, originalRequest, true);
    }
    @Override
    public T is(short value) {
        getFilter().setModifier(Modifier.EQUALS);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isNot(short value) {
        getFilter().setModifier(Modifier.NOT_EQUALS);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isLessThan(short value) {
        getFilter().setModifier(Modifier.LESS);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isLessThanOrEqualTo(short value) {
        getFilter().setModifier(Modifier.LESS_OR_EQUAL);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isGreaterThan(short value) {
        getFilter().setModifier(Modifier.GREATER);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isGreaterThanOrEqualTo(short value) {
        getFilter().setModifier(Modifier.GREATER_OR_EQUAL);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isBetween(short from, short to) {
        short[] values = smallestToHighest(from, to);
        getFilter().setModifier(Modifier.BETWEEN);
        getFilter().setPrimaryValue(String.valueOf(values[0]));
        getFilter().setSecondaryValue(String.valueOf(values[1]));
        return getOriginalRequest();
    }
    @Override
    public T isBetweenOrEqualTo(short from, short to) {
        short[] values = smallestToHighest(from, to);
        getFilter().setModifier(Modifier.BETWEEN_OR_EQUAL);
        getFilter().setPrimaryValue(String.valueOf(values[0]));
        getFilter().setSecondaryValue(String.valueOf(values[1]));
        return getOriginalRequest();
    }
    private short[] smallestToHighest(short from, short to) {
        short[] values = new short[2];
        values[0] = (from <= to) ? from : to;
        values[1] = (from <= to) ? to : from;
        return values;
    }
}
