
package org.blufin.sdk.filters.dynamic;
import org.blufin.sdk.base.AbstractFilter;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.FilterType;
import org.blufin.sdk.filters.Modifier;
import org.blufin.sdk.filters.interfaces.IntegerTinyFilterable;
import java.util.List;
public class FilterIntegerTiny<T> extends FilterBase<T> implements IntegerTinyFilterable<T> {
    public FilterIntegerTiny(AbstractFilter filter, List<Filter> filters, T originalRequest) {
        super(FilterType.INTEGER_TINY, filter, filters, originalRequest, true);
    }
    @Override
    public T is(byte value) {
        getFilter().setModifier(Modifier.EQUALS);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isNot(byte value) {
        getFilter().setModifier(Modifier.NOT_EQUALS);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isLessThan(byte value) {
        getFilter().setModifier(Modifier.LESS);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isLessThanOrEqualTo(byte value) {
        getFilter().setModifier(Modifier.LESS_OR_EQUAL);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isGreaterThan(byte value) {
        getFilter().setModifier(Modifier.GREATER);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isGreaterThanOrEqualTo(byte value) {
        getFilter().setModifier(Modifier.GREATER_OR_EQUAL);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T isBetween(byte from, byte to) {
        byte[] values = smallestToHighest(from, to);
        getFilter().setModifier(Modifier.BETWEEN);
        getFilter().setPrimaryValue(String.valueOf(values[0]));
        getFilter().setSecondaryValue(String.valueOf(values[1]));
        return getOriginalRequest();
    }
    @Override
    public T isBetweenOrEqualTo(byte from, byte to) {
        byte[] values = smallestToHighest(from, to);
        getFilter().setModifier(Modifier.BETWEEN_OR_EQUAL);
        getFilter().setPrimaryValue(String.valueOf(values[0]));
        getFilter().setSecondaryValue(String.valueOf(values[1]));
        return getOriginalRequest();
    }
    private byte[] smallestToHighest(byte from, byte to) {
        byte[] values = new byte[2];
        values[0] = (from <= to) ? from : to;
        values[1] = (from <= to) ? to : from;
        return values;
    }
}
