
package org.blufin.sdk.filters.dynamic;
import org.blufin.sdk.base.AbstractFilter;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.FilterType;
import org.blufin.sdk.filters.Modifier;
import org.blufin.sdk.filters.interfaces.ContentFilterable;
import java.util.List;
public class FilterText<T> extends FilterBase<T> implements ContentFilterable<T, String> {
    public FilterText(AbstractFilter filter, List<Filter> filters, T originalRequest) {
        super(FilterType.TEXT, filter, filters, originalRequest, true);
    }
    @Override
    public T contains(String value) {
        getFilter().setModifier(Modifier.CONTAINS);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T doesNotContain(String value) {
        getFilter().setModifier(Modifier.NOT_CONTAINS);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T startsWith(String value) {
        getFilter().setModifier(Modifier.STARTS_WITH);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T doesNotStartWith(String value) {
        getFilter().setModifier(Modifier.NOT_STARTS_WITH);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T endsWith(String value) {
        getFilter().setModifier(Modifier.ENDS_WITH);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
    @Override
    public T doesNotEndWith(String value) {
        getFilter().setModifier(Modifier.NOT_ENDS_WITH);
        getFilter().setPrimaryValue(String.valueOf(value));
        return getOriginalRequest();
    }
}
