
package org.blufin.sdk.filters.interfaces;
import org.blufin.sdk.filters.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
public interface ContentFilterable<T, D> {
    List<Modifier> modifiers = Collections.unmodifiableList(Arrays.asList(Modifier.CONTAINS, Modifier.NOT_CONTAINS, Modifier.STARTS_WITH, Modifier.NOT_STARTS_WITH, Modifier.ENDS_WITH, Modifier.NOT_ENDS_WITH));
    T contains(D value);
    T doesNotContain(D value);
    T startsWith(D value);
    T doesNotStartWith(D value);
    T endsWith(D value);
    T doesNotEndWith(D value);
}
