
package org.blufin.sdk.filters.interfaces;
import java.math.BigDecimal;
public interface DecimalFilterable<T> {
    T is(BigDecimal value);
    T isNot(BigDecimal value);
    T isLessThan(BigDecimal value);
    T isLessThanOrEqualTo(BigDecimal value);
    T isGreaterThan(BigDecimal value);
    T isGreaterThanOrEqualTo(BigDecimal value);
    T isBetween(BigDecimal from, BigDecimal to);
    T isBetweenOrEqualTo(BigDecimal from, BigDecimal to);
}
