
package org.blufin.sdk.filters.interfaces;
import org.blufin.sdk.filters.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
public interface IntegerFilterable<T> {
    List<Modifier> modifiers = Collections.unmodifiableList(Arrays.asList(Modifier.EQUALS, Modifier.NOT_EQUALS, Modifier.LESS, Modifier.LESS_OR_EQUAL, Modifier.GREATER, Modifier.GREATER_OR_EQUAL, Modifier.BETWEEN, Modifier.BETWEEN_OR_EQUAL));
    T is(int value);
    T isNot(int value);
    T isLessThan(int value);
    T isLessThanOrEqualTo(int value);
    T isGreaterThan(int value);
    T isGreaterThanOrEqualTo(int value);
    T isBetween(int from, int to);
    T isBetweenOrEqualTo(int from, int to);
}
