
package org.blufin.sdk.filters.interfaces;
import org.blufin.sdk.filters.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
public interface MatchComparisonFilterable<T, D> {
    List<Modifier> modifiers = Collections.unmodifiableList(Arrays.asList(Modifier.EQUALS, Modifier.NOT_EQUALS, Modifier.LESS, Modifier.LESS_OR_EQUAL, Modifier.GREATER, Modifier.GREATER_OR_EQUAL, Modifier.BETWEEN, Modifier.BETWEEN_OR_EQUAL));
    T is(D value);
    T isNot(D value);
    T isLessThan(D value);
    T isLessThanOrEqualTo(D value);
    T isGreaterThan(D value);
    T isGreaterThanOrEqualTo(D value);
    T isBetween(D from, D to);
    T isBetweenOrEqualTo(D from, D to);
}
