
package org.blufin.sdk.filters.interfaces;
import org.blufin.sdk.filters.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
public interface MatchContentFilterable<T> {
    List<Modifier> modifiers = Collections.unmodifiableList(Arrays.asList(Modifier.EQUALS, Modifier.NOT_EQUALS, Modifier.CONTAINS, Modifier.NOT_CONTAINS, Modifier.STARTS_WITH, Modifier.NOT_STARTS_WITH, Modifier.ENDS_WITH, Modifier.NOT_ENDS_WITH));
    T is(String value);
    T isNot(String value);
    T contains(String value);
    T doesNotContain(String value);
    T startsWith(String value);
    T doesNotStartWith(String value);
    T endsWith(String value);
    T doesNotEndWith(String value);
}
