
package org.blufin.sdk.helper;
import org.blufin.base.exceptions.BlufinAlertDeveloperException;
import org.blufin.sdk.base.PersistentDto;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
public final class IdHelper {
    public static final <T> Set<T> findMissing(List<T> a, List<T> b) {
        return findMissing(new HashSet<>(a), new HashSet<>(b));
    }
    public static final <T> Set<T> findMissing(Set<T> a, Set<T> b) {
        Set<T> c = new HashSet<>(a);
        c.removeAll(b);
        c.removeAll(Collections.singleton(null));
        return c;
    }
    public static final boolean isValid(Integer id) {
        return id != null && id > 0;
    }
    public static final Set<Integer> extractIds(List<? extends PersistentDto> dtos) {
        Set<Integer> ids = new HashSet<>();
        dtos.forEach(dto -> {
            if (isValid(dto.getId())) {
                ids.add(dto.getId());
            }
        });
        return ids;
    }
    public static final Integer extractParentId(List<? extends PersistentDto> dtos) {
        Set<Integer> ids = new HashSet<>();
        dtos.forEach(dto -> {
            if (isValid(dto.getParentId())) {
                ids.add(dto.getParentId());
            }
        });
        if (ids.size() == 0) {
            return null;
        } else if (ids.size() == 1) {
            return ids.iterator().next();
        } else {
            throw new BlufinAlertDeveloperException(MessageFormat.format("{0}.extractParentId() resolved more than 1 ID: {1}", IdHelper.class.getSimpleName(), ids.toString()));
        }
    }
    public static final void addParentId(List<? extends PersistentDto> dtos, int parentId) {
        if (parentId <= 0) {
            return;
        }
        dtos.forEach(dto -> {
            if (dto.getParentId() == null) {
                dto.setParentId(parentId);
            }
        });
    }
    public static final void addParentId(PersistentDto dto, int parentId) {
        if (parentId <= 0) {
            return;
        }
        if (dto.getParentId() == null) {
            dto.setParentId(parentId);
        }
    }
}
