
package org.blufin.sdk.normalization;
import org.blufin.base.enums.TimeZone;
import org.blufin.sdk.response.AckError;
import org.blufin.sdk.response.AckResolver;
import org.blufin.base.helper.Triplet;
import org.blufin.base.utils.UtilsRegex;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
public class DateTimeSplitter {
    private static final Pattern REGEX_TIME = Pattern.compile("^([0-9]|0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]");
    private static final Pattern REGEX_MILLISECONDS = Pattern.compile("^\\.{1}\\d{1,9}");
    private static final Pattern REGEX_TIMEZONE = Pattern.compile("^(((\\+|-)(0[0-9]|1[0-9]|2[0-3]):[0-5][0-9])|Z)?(\\[[^\\[\\]\\s]+\\])?$");
    public static final Triplet<String, String, String> splitTimeNanoAndZone(String value, String element, AckResolver ackResolver) throws DataNormalizationException {
        String t;
        String m = null;
        String z = null;
        value = value.trim();
        if (value.equals("")) {
            return Triplet.of(null, null, null);
        }
        if (UtilsRegex.stringMatchesRegex(value, REGEX_TIME)) {
            t = value.substring(0, 8);
            value = value.substring(8);
            Matcher msMatcher = REGEX_MILLISECONDS.matcher(value);
            if (msMatcher.find()) {
                m = msMatcher.group(0).substring(1);
                value = value.substring(m.length() + 1);
            }
            if (!value.trim().equals("")) {
                if (value.toUpperCase().equals(TimeZone.UTC.getZoneIdDisplay())) {
                    z = TimeZone.UTC.getZoneIdDisplay();
                } else if (UtilsRegex.stringMatchesRegex(value, REGEX_TIMEZONE)) {
                    z = value;
                    if (value.substring(0, 1).equals("[") && value.substring(z.length() - 1).equals("]")) {
                        z = TimeZone.UTC.getZoneIdDisplay() + z;
                    }
                } else {
                    ackResolver.addError(AckError.DATETIME_INVALID_TIMEZONE, value, element);
                    throw new DataNormalizationException();
                }
            }
        } else {
            throw new DataNormalizationException();
        }
        return Triplet.of(t, m, z);
    }
}
