
package org.blufin.sdk.normalization;
import org.blufin.base.constants.Constants;
import org.blufin.base.helper.Pair;
import java.math.BigDecimal;
public class DecimalHelper {
    public static BigDecimal getMinimumAllowedValue(Pair decimalDistribution) {
        int m = (int) decimalDistribution.getKey();
        int d = (int) decimalDistribution.getValue();
        if (m < d) {
            throw new IllegalArgumentException("When calculating minimum allowed Decimal value, m (" + m + ") cannot be smaller than d (" + d + ").");
        }
        BigDecimal zero = new BigDecimal(0);
        BigDecimal maximumAllowedValue = getMaximumAllowedValue(decimalDistribution);
        return zero.subtract(maximumAllowedValue);
    }
    public static BigDecimal getMaximumAllowedValue(Pair decimalDistribution) {
        int m = (int) decimalDistribution.getKey();
        int d = (int) decimalDistribution.getValue();
        if (m < d) {
            throw new IllegalArgumentException("When calculating maximum allowed Decimal value, m (" + m + ") cannot be smaller than d (" + d + ").");
        }
        String decimal = new String(new char[m]).replace("\0", "9");
        decimal = decimal.substring(0, m - d) + Constants.PERIOD + decimal.substring(m - d);
        return new BigDecimal(decimal);
    }
}
