
package org.blufin.sdk.normalization;
public class TerminologyNormalizer {
    public static Type type(String nodeType) {
        switch (nodeType.toLowerCase()) {
            case "array":
            case "arraylist":
            case "list":
                return Type.LIST;
            case "boolean":
                return Type.BOOLEAN;
            case "number":
                return Type.NUMBER;
            case "null":
                return Type.NULL;
            case "string":
                return Type.STRING;
            case "object":
            default:
                return Type.OBJECT;
        }
    }
    public enum Type {
        BOOLEAN, NUMBER, NULL, LIST, OBJECT, STRING
    }
}
