
package org.blufin.sdk.request;
import org.blufin.base.exceptions.BlufinNotImplementedException;
import org.blufin.base.helper.Pair;
import org.blufin.sdk.base.*;
import org.blufin.sdk.service.credentials.ApiCredentials;
import org.blufin.sdk.enums.SortOrder;
import org.blufin.sdk.filters.FilterContainer;
import org.blufin.sdk.request.credentials.RequestCredentials;
import java.lang.reflect.Constructor;
import java.util.List;
public class PaginatedGetRequest<DTO extends PersistentDto, FIELD extends AbstractField, SORT extends AbstractSort, REFINER extends Refiner> extends GetRequestBase<DTO, FIELD, SORT> {
    protected final Class<REFINER> refiner;
    protected final AbstractMapperEmbedded embeddedMapped;
    protected Constructor<?> refinerImplCache;
    public PaginatedGetRequest(ApiCredentials apiCredentials, String endPoint, Class<DTO> responseDto, AbstractMetaData metaData, Class<REFINER> refiner) {
        super(apiCredentials, endPoint, responseDto, metaData, null);
        this.embeddedMapped = null;
        this.refiner = refiner;
    }
    public PaginatedGetRequest(ApiCredentials apiCredentials, String endPoint, Class<DTO> responseDto, AbstractMetaData metaData, Class<REFINER> refiner, RequestCredentials requestCredentials) {
        super(apiCredentials, endPoint, responseDto, metaData, requestCredentials);
        this.embeddedMapped = null;
        this.refiner = refiner;
    }
    public PaginatedGetRequest<DTO, FIELD, SORT, REFINER> page(int page) {
        setPageInternal(page);
        return this;
    }
    public PaginatedGetRequest<DTO, FIELD, SORT, REFINER> entries(int entries) {
        setEntriesInternal(entries);
        return this;
    }
    public PaginatedGetRequest<DTO, FIELD, SORT, REFINER> sortBy(SORT sortableField) {
        setSortInternal(Pair.of(sortableField, SortOrder.ASC));
        return this;
    }
    public PaginatedGetRequest<DTO, FIELD, SORT, REFINER> sortBy(SORT sortableField, SortOrder sortOrder) {
        setSortInternal(Pair.of(sortableField, sortOrder));
        return this;
    }
    public PaginatedGetRequest<DTO, FIELD, SORT, REFINER> sortBy(List<Pair<SORT, SortOrder>> sortList) {
        setSortInternal(sortList);
        return this;
    }
    public REFINER where() {
        try {
            return (REFINER) getRefiner().newInstance(getFilterList(), this);
        } catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
    public PaginatedGetRequest<DTO, FIELD, SORT, REFINER> where(FilterContainer filterContainer) {
        throw new BlufinNotImplementedException();
    }
    protected Constructor<?> getRefiner() {
        try {
            if (this.refinerImplCache == null) {
                this.refinerImplCache = Class.forName(refiner.getName()).getConstructor(List.class, PaginatedGetRequest.class);
            }
            return refinerImplCache;
        } catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}
