
package org.blufin.sdk.request;
import com.mashape.unirest.http.HttpMethod;
import lombok.AccessLevel;
import lombok.Getter;
import org.blufin.sdk.base.PersistentDto;
import org.blufin.sdk.enums.AuthHeader;
import org.blufin.sdk.request.credentials.RequestCredentials;
import org.blufin.sdk.service.credentials.ApiCredentials;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
@Getter(AccessLevel.PROTECTED)
public abstract class RequestBase<DTO extends PersistentDto> {
    private final ApiCredentials apiCredentials;
    private final String endPoint;
    private final Class<DTO> responseDto;
    private final HttpMethod httpMethod;
    private RequestCredentials requestCredentials;
    public RequestBase(ApiCredentials apiCredentials, String endPoint, Class<DTO> responseDto, RequestCredentials requestCredentials, HttpMethod httpMethod) {
        this.endPoint = endPoint;
        this.responseDto = responseDto;
        this.apiCredentials = apiCredentials;
        this.requestCredentials = requestCredentials;
        this.httpMethod = httpMethod;
    }
    protected Map<String, String> buildHeaders() {
        Map<String, String> headers = new HashMap<>();
        switch (apiCredentials.getApiCredentialsType()) {
            case INTERNAL:
                throw new RuntimeException("When using a ResourceLocator to make API requests internally the code should never hit here.");
            case HTTP:
                headers.put(AuthHeader.AUTH_INTERNAL.toString(), apiCredentials.getAuthorizationHeader());
                if (requestCredentials != null) {
                    if (requestCredentials.getAccountUser() > -1) {
                        headers.put(AuthHeader.AUTH_ACCOUNT_USER.toString(), String.valueOf(requestCredentials.getAccountUser()));
                    }
                    if (requestCredentials.getAccountName() != null) {
                        headers.put(AuthHeader.AUTH_ACCOUNT_NAME.toString(), requestCredentials.getAccountName());
                    }
                }
                break;
            case HTTP_OAUTH:
                headers.put(AuthHeader.X_OAUTH_DEV.toString(), apiCredentials.getDeveloperKey());
                headers.put(AuthHeader.X_OAUTH_APP.toString(), apiCredentials.getApplicationKey());
                if (requestCredentials != null) {
                    if (requestCredentials.getAccountUser() > 0) {
                        headers.put(AuthHeader.X_OAUTH_ACCOUNT_USER.toString(), String.valueOf(requestCredentials.getAccountUser()));
                    }
                    if (requestCredentials.getAccountToken() != null) {
                        headers.put(AuthHeader.X_OAUTH_ACCOUNT_TOKEN.toString(), requestCredentials.getAccountToken());
                    }
                }
                break;
            default:
                throw new RuntimeException(MessageFormat.format("Unrecognized ApiCredentialsType: {0}", apiCredentials.getApiCredentialsType().toString()));
        }
        return headers;
    }
}
