
package org.blufin.sdk.request.type;
import org.blufin.base.helper.IdSet;
import org.blufin.sdk.base.PersistentDto;
import org.blufin.sdk.base.AbstractMetaData;
import org.blufin.sdk.base.Refiner;
import org.blufin.sdk.enums.RequestType;
import org.blufin.sdk.request.IdSetGetRequest;
import org.blufin.sdk.request.PaginatedGetRequest;
import org.blufin.sdk.request.credentials.RequestCredentials;
import org.blufin.sdk.service.credentials.ApiCredentials;
import java.text.MessageFormat;
public abstract class AbstractRequest<T> {
    protected final ApiCredentials apiCredentials;
    protected final String endPoint;
    protected final Class<? extends PersistentDto> responseDto;
    protected final AbstractMetaData metaData;
    protected final RequestType requestType;
    protected Class<? extends Refiner> refiner;
    protected IdSet idSet;
    public AbstractRequest(ApiCredentials apiCredentials, String endPoint, Class<? extends PersistentDto> responseDto, AbstractMetaData metaData, Class<? extends Refiner> refiner) {
        this.apiCredentials = apiCredentials;
        this.endPoint = endPoint;
        this.responseDto = responseDto;
        this.metaData = metaData;
        this.refiner = refiner;
        this.requestType = RequestType.PAGINATED;
    }
    public AbstractRequest(ApiCredentials apiCredentials, String endPoint, Class<? extends PersistentDto> responseDto, AbstractMetaData metaData, IdSet idSet) {
        this.apiCredentials = apiCredentials;
        this.endPoint = endPoint;
        this.responseDto = responseDto;
        this.metaData = metaData;
        this.idSet = idSet;
        this.requestType = RequestType.IDSET;
    }
    protected T requestObject(RequestCredentials requestCredentials) {
        switch (requestType) {
            case PAGINATED:
                return (T) new PaginatedGetRequest(apiCredentials, endPoint, responseDto, metaData, refiner, requestCredentials);
            case IDSET:
                return (T) new IdSetGetRequest(apiCredentials, endPoint, responseDto, metaData, idSet, requestCredentials);
            default:
                throw new RuntimeException(MessageFormat.format("Unrecognized RequestType: {0}", requestType.toString()));
        }
    }
}
