
package org.blufin.sdk.request.type;
import org.blufin.base.helper.IdSet;
import org.blufin.sdk.base.AbstractClientData;
import org.blufin.sdk.base.PersistentDto;
import org.blufin.sdk.base.AbstractMetaData;
import org.blufin.sdk.base.Refiner;
import org.blufin.sdk.request.credentials.InternalAccountUserCredentials;
import org.blufin.sdk.service.credentials.ApiCredentials;
public class AccountUserRequest<T> extends AbstractRequest<T> {
    public AccountUserRequest(ApiCredentials apiCredentials, String endPoint, Class<? extends PersistentDto> responseDto, AbstractMetaData metaData, Class<? extends Refiner> refiner) {
        super(apiCredentials, endPoint, responseDto, metaData, refiner);
    }
    public AccountUserRequest(ApiCredentials apiCredentials, String endPoint, Class<? extends PersistentDto> responseDto, AbstractMetaData metaData, IdSet idSet) {
        super(apiCredentials, endPoint, responseDto, metaData, idSet);
    }
    public T as(String accountName, int userId) {
        return requestObject(new InternalAccountUserCredentials(accountName, userId));
    }
    public T as(AbstractClientData clientData) {
        return requestObject(new InternalAccountUserCredentials(clientData.getAccount().getAccountName(), clientData.getUser().getId()));
    }
}
