
package org.blufin.sdk.request.type;
import org.blufin.base.helper.IdSet;
import org.blufin.sdk.base.PersistentDto;
import org.blufin.sdk.base.AbstractMetaData;
import org.blufin.sdk.base.Refiner;
import org.blufin.sdk.request.credentials.OAuthAccountCredentials;
import org.blufin.sdk.service.credentials.ApiCredentials;
public class OAuthAccount<T> extends AbstractRequest<T> {
    public OAuthAccount(ApiCredentials apiCredentials, String endPoint, Class<? extends PersistentDto> responseDto, AbstractMetaData metaData, Class<? extends Refiner> refiner) {
        super(apiCredentials, endPoint, responseDto, metaData, refiner);
    }
    public OAuthAccount(ApiCredentials apiCredentials, String endPoint, Class<? extends PersistentDto> responseDto, AbstractMetaData metaData, IdSet idSet) {
        super(apiCredentials, endPoint, responseDto, metaData, idSet);
    }
    public T as(String accountToken) {
        return requestObject(new OAuthAccountCredentials(accountToken));
    }
}
