
package org.blufin.sdk.request.type;
import org.blufin.base.helper.IdSet;
import org.blufin.sdk.base.PersistentDto;
import org.blufin.sdk.base.AbstractMetaData;
import org.blufin.sdk.base.Refiner;
import org.blufin.sdk.request.credentials.OAuthAccountUserCredentials;
import org.blufin.sdk.service.credentials.ApiCredentials;
public class OAuthAccountUser<T> extends AbstractRequest<T> {
    public OAuthAccountUser(ApiCredentials apiCredentials, String endPoint, Class<? extends PersistentDto> responseDto, AbstractMetaData metaData, Class<? extends Refiner> refiner) {
        super(apiCredentials, endPoint, responseDto, metaData, refiner);
    }
    public OAuthAccountUser(ApiCredentials apiCredentials, String endPoint, Class<? extends PersistentDto> responseDto, AbstractMetaData metaData, IdSet idSet) {
        super(apiCredentials, endPoint, responseDto, metaData, idSet);
    }
    public T as(String accountToken, int userId) {
        return requestObject(new OAuthAccountUserCredentials(accountToken, userId));
    }
}
