
package org.blufin.sdk.response;
import lombok.Getter;
import org.blufin.base.constants.Constants;
import org.blufin.sdk.base.AbstractMetaData;
import org.blufin.sdk.constants.SdkConstants;
import java.text.MessageFormat;
import java.util.List;
@Getter
public enum AckError {
    BOOLEAN_BLANK(Type.CLIENT, "Boolean value provided for ''{0}'' is blank. Expected ''true'' or ''false''."),
    BOOLEAN_INVALID(Type.CLIENT, "Boolean value provided for ''{1}'' is invalid. Expected ''true'' or ''false''. Got → ''{0}''"),
    BYTE_BLANK(Type.CLIENT, "Value provided for ''{0}'' is blank."),
    BYTE_INVALID(Type.CLIENT, "Value provided for ''{1}'' is invalid. Got → {0}"),
    BYTE_CONTAINED_DECIMAL_POINT(Type.CLIENT, "Value provided for ''{1}'' cannot contain a decimal point. Got → {0}"),
    BYTE_OUT_OF_BOUNDS(Type.CLIENT, "Value provided for ''{1}'' is out of bounds. Expected value between -128 & 127. Got → {0}"),
    DATE_BLANK(Type.CLIENT, "Date value provided for ''{0}'' is blank. This resource expected: yyyy-MM-dd"),
    DATE_INVALID_FORMAT(Type.CLIENT, "Date value provided for ''{1}'' is incorrectly formatted somehow (or has a non-existent date). This resource expected: yyyy-MM-dd. Got → {0}"),
    DATETIME_BLANK(Type.CLIENT, "Datetime value provided for ''{0}'' is blank. This resource expected: yyyy-MM-ddTHH:mm:ss.SSSZ"),
    DATETIME_INVALID_FORMAT(Type.CLIENT, "Datetime value provided for ''{1}'' is incorrectly formatted somehow (or has a non-existent date, time or timezone). This resource expected: yyyy-MM-ddTHH:mm:ss.SSSZ. Got → {0}"),
    DATETIME_INVALID_TIMEZONE(Type.CLIENT, "Timezone provided for ''{1}'' is not supported by this resource. Invalid Timezone identifier → {0}"),
    DATETIME_TIME_TOO_GRANULAR(Type.CLIENT, "Datetime value provided for ''{1}'' had a time value too granular for this resource to handle. Datetime is stored at an accuracy of 1/1000th of a second. This resource expected: yyyy-MM-ddTHH:mm:ss.SSSZ. Got → {0}"),
    DECIMAL_BLANK(Type.CLIENT, "Decimal value provided for ''{0}'' is blank."),
    DECIMAL_INVALID(Type.CLIENT, "Decimal value provided for ''{1}'' is invalid. Got → {0}"),
    DECIMAL_OUT_OF_BOUNDS(Type.CLIENT, "Decimal value provided for ''{1}'' is out of bounds. Expected value between {2} & {3}. Got → {0}"),
    DECIMAL_TOO_GRANULAR(Type.CLIENT, "Decimal value provided for ''{1}'' has more decimal places than expected from which a precise value cannot be safely inferred. This resource expected DECIMAL({2},{3}). Got → {0}"),
    DUPLICATE_IDS_IN_LIST(Type.CLIENT, "Duplicate ID ''{0}'' found in " + List.class.getSimpleName() + " of ''{1}'' Objects at indexes: {2}"),
    EMPTY_PAYLOAD(Type.CLIENT, "Empty payload."),
    ENTRIES_UNDER_MINIMUM(Type.CLIENT, "Value provided for " + SdkConstants.ENTRIES.toUpperCase() + " cannot be less than (or equal to) 0. Got → {0}"),
    ENTRIES_EXCEEDED_MAXIMUM(Type.CLIENT, "Value provided for " + SdkConstants.ENTRIES.toUpperCase() + " cannot exceed the maximum of " + SdkConstants.API_MAXIMUM_ENTRIES + ". Got → {0}"),
    FIELD_HOLDS_COLLECTION(Type.CLIENT, "{1} not {2} because it holds a {3} collection. Cannot {4} on → {0}"),
    FIELD_IS_ENCRYPTED(Type.CLIENT, "Cannot apply {1} to encrypted property → {0}"),
    FIELD_NAME_INVALID(Type.CLIENT, "Property ''{0}'' (for {1}) is not supported by this resource. Available properties are → {2}"),
    FIELD_NAME_INVALID_SYNTAX(Type.CLIENT, "Property name (for {1}) is incorrectly formatted. Invalid syntax → ''{0}''"),
    FIELD_NAME_INVALID_NESTED(Type.CLIENT, "Nested property ''{0}'' (for {1}) is not part of this resource hierarchy. Available properties for ''{2}'' are → {3}"),
    FIELD_NAME_INVALID_NESTED_TABLE(Type.CLIENT, "Nested property ''{0}'' (for {1}) is not part of this resource hierarchy. Available nested properties are → {2}"),
    FILTER_DATETIME_MISSING_TIMEZONE(Type.CLIENT, "Datetime value provided for {2} is missing timezone information. This resource expected: yyyy-MM-ddTHH:mm:ss.SSSZ. Value {0} was interpreted as → {1}"),
    FILTER_DESERIALIZATION_FAILURE(Type.CLIENT, "JSON is structured in a way not recognized by this resource. Expected something similar to: {0} . Got → {1}"),
    FILTER_INVALID_MODIFIER(Type.CLIENT, "The modifier provided for ''{1}'' is not recognized by this resource. Invalid modifier → {0}"),
    FILTER_INVALID_MODIFIER_BLANK(Type.CLIENT, "The modifier provided for ''{0}'' is blank."),
    FILTER_INVALID_MODIFIER_FOR_TYPE(Type.CLIENT, "The modifier provided for ''{1}'' is incompatible with its type: {2}. Unsupported modifier → {0}"),
    FILTER_MISSING_MODIFIER(Type.CLIENT, "Filter for property ''{0}'' has no modifier — expected to be the 2nd parameter."),
    FILTER_MISSING_PRIMARY_VALUE(Type.CLIENT, "Filter for property ''{0}'' has no primary value — expected to be the 3rd parameter."),
    FILTER_MISSING_SECONDARY_VALUE(Type.CLIENT, "Filter for property ''{0}'' has no secondary value — expected to be the 4th parameter."),
    FORBIDDEN(Type.CLIENT, "You do not have permission(s) to access this resource."),
    ID_NOT_EXPECTED(Type.CLIENT, "DTOs marked for INSERTION should not have ID. Found → ''{1}'' : {0}"),
    INT_BLANK(Type.CLIENT, "Value provided for ''{0}'' is blank."),
    INT_INVALID(Type.CLIENT, "Value provided for ''{1}'' is invalid. Got → {0}"),
    INT_CONTAINED_DECIMAL_POINT(Type.CLIENT, "Value provided for ''{1}'' cannot contain a decimal point. Got → {0}"),
    INT_OUT_OF_BOUNDS(Type.CLIENT, "Value provided for ''{1}'' is out of bounds. Expected value between -2147483648 & 2147483647. Got → {0}"),
    JSON_ERROR(Type.CLIENT, "{0}"),
    JSON_MISSING_PROPERTIES(Type.CLIENT, "The following properties are required by this resource → {0}"),
    JSON_NULL_NOT_ALLOWED(Type.CLIENT, "Value provided for ''{0}'' cannot be null. Expected → {1}"),
    JSON_NULL_NOT_ALLOWED_CONDITIONAL(Type.CLIENT, "Value provided for ''{0}'' cannot be null when ''{1}'' is: {2}. Expected → {3} "),
    JSON_NULL_REQUIRED_CONDITIONAL(Type.CLIENT, "Value provided for ''{0}'' must be null unless ''{1}'' is: {2}. ''{1}'' is → {3}"),
    JSON_NULL_NOT_ALLOWED_FOR_LIST(Type.CLIENT, "Value provided for ''{0}'' cannot be null. Value must always be a " + List.class.getSimpleName() + " even if the " + List.class.getSimpleName() + " is empty (IE: [])."),
    JSON_SERVER_ERROR(Type.SERVER, "This resource encountered an unhandled JSON processing error."),
    JSON_TYPE_MISMATCH(Type.CLIENT, "''{0}'' expected data-type of: {1} . Got → {2}"),
    JSON_UNRECOGNIZED_PROPERTIES(Type.CLIENT, "The following properties are not supported by this resource → {0}"),
    LONG_BLANK(Type.CLIENT, "Value provided for ''{0}'' is blank."),
    LONG_INVALID(Type.CLIENT, "Value provided for ''{1}'' is invalid. Got → {0}"),
    LONG_CONTAINED_DECIMAL_POINT(Type.CLIENT, "Value provided for ''{1}'' cannot contain a decimal point. Got → {0}"),
    LONG_OUT_OF_BOUNDS(Type.CLIENT, "Value provided for ''{1}'' is out of bounds. Expected value between -9223372036854775808 & 9223372036854775807. Got → {0}"),
    OBJECT_ALREADY_EXISTS(Type.CLIENT, "Cannot create ''{1}'' with ''{2}'' : {0}. An Object with the same parent ID already exists."),
    OBJECT_HAS_DEPENDENTS(Type.CLIENT, "Cannot delete ''{1}'' with ID: {0} because other Object(s) are dependent on it: {2}"),
    OBJECT_NOT_FOUND(Type.CLIENT, "Unable to find ''{1}'' with ID: {0}{2}"),
    OBJECT_REQUIRES_ID(Type.CLIENT, "''{1}'' requires ID. Found → ''" + AbstractMetaData.ID + "'' : {0}"),
    PAGE_UNDER_MINIMUM(Type.CLIENT, "Value provided for " + SdkConstants.PAGE.toUpperCase() + " cannot be less than (or equal to) 0. Got → {0}"),
    PARENT_CHILD_ID_MISMATCH(Type.CLIENT, "Parent and Child ID must be the same. ''{2}'' : {0} does not match → ''{3}'' : {1}"),
    PARENT_ID_MISSING(Type.CLIENT, "Parent ID was missing, " + Constants.NULL + " or invalid. Got → ''{1}'' : {0}"),
    PARENT_IDS_MUST_MATCH(Type.CLIENT, "Parent IDs must point to the same parent Object. Found multiple IDs for {1} → {0}"),
    PARENT_NOT_FOUND(Type.CLIENT, "Unable to find ''{1}'' for ''{2}'' : {0}"),
    PARENT_ID_NOT_EXPECTED(Type.CLIENT, "Child DTOs where parent(s) are marked for INSERTION cannot have parent ID. Found → ''{1}'' : {0}"),
    RESOURCE_NOT_FOUND(Type.CLIENT, "The requested URI does not exist on this server: {0}"),
    SHORT_BLANK(Type.CLIENT, "Value provided for ''{0}'' is blank."),
    SHORT_INVALID(Type.CLIENT, "Value provided for ''{1}'' is invalid. Got → {0}"),
    SHORT_CONTAINED_DECIMAL_POINT(Type.CLIENT, "Value provided for ''{1}'' cannot contain a decimal point. Got → {0}"),
    SHORT_OUT_OF_BOUNDS(Type.CLIENT, "Value provided for ''{1}'' is out of bounds. Expected value between -32768 & 32767. Got → {0}"),
    SORT_DESERIALIZATION_FAILURE(Type.CLIENT, "JSON is structured in a way not recognized by this resource. Expected something similar to: {0} . Got → {1}"),
    SORT_ORDER_NOT_SUPPORTED(Type.CLIENT, "Sort order value provided for ''{1}'' is invalid. Expected ''{2}'' or ''{3}'' . Got → {0}"),
    SORT_NESTED_NOT_SUPPORTED(Type.CLIENT, "Sort currently not supported for nested Objects. Invalid sort parameter → {0}"),
    STRING_ENUM_BLANK(Type.CLIENT, "Enum value provided for ''{0}'' is blank."),
    STRING_ENUM_INVALID(Type.CLIENT, "Enum value provided for ''{1}'' is not a value supported by this resource. Valid values are: {2}. Got → {0}"),
    STRING_MAX_LENGTH_EXCEEDED(Type.CLIENT, "Value provided for ''{1}'' has too many characters. Maximum allowed length is: {2}. Got → ''{0}'' ({3} characters)"),
    UNAUTHORIZED(Type.CLIENT, "You are not authorized to access this resource."),
    URL_ENCODING_ERROR(Type.CLIENT, "Query parameter ''{1}'' could not be successfully URL decoded. Invalid value → {0}");
    private final Type type;
    private final String message;
    AckError(Type type, String message) {
        this.type = type;
        this.message = message;
    }
    public String toString() {
        return this.name() + " - " + message;
    }
    public String toString(String... args) {
        return this.name() + " - " + MessageFormat.format(message, (Object[]) args);
    }
    private enum Type {
        CLIENT, SERVER
    }
}
