
package org.blufin.sdk.response;
import lombok.Getter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
public class AckResolver {
    @Getter
    private List<String> errors = new ArrayList<>();
    @Getter
    private List<String> warnings = new ArrayList<>();
    public void addError(AckError error, String... args) {
        this.errors.add(error.name() + " - " + MessageFormat.format(error.getMessage(), (String[]) args));
    }
    public void addWarning(AckWarning warning, String... args) {
        this.warnings.add(warning.name() + " - " + MessageFormat.format(warning.getMessage(), (String[]) args));
    }
    public boolean contains(AckError error) {
        for (int i = 0; i < errors.size(); i++) {
            if (errors.get(i).startsWith(error.toString())) {
                return true;
            }
        }
        return false;
    }
    public boolean contains(AckWarning warning) {
        for (int i = 0; i < warnings.size(); i++) {
            if (warnings.get(i).startsWith(warning.toString())) {
                return true;
            }
        }
        return false;
    }
}
