
package org.blufin.sdk.response;
import lombok.Data;
import java.util.List;
@Data
public class ApiResponse<T> extends ApiResponseBase {
    public static final String DATA = "data";
    public static final String PAGINATION = "pagination";
    public static final String RESPONSE_CODE = "responseCode";
    public static final String RESPONSE_TYPE = "responseType";
    private List<T> body;
    private Object metaData;
    private ApiResponsePagination pagination;
    private List<String> stackTrace;
    public ApiResponse(HttpStatus status) {
        this.code = status.getCode();
        this.status = status.getReason();
    }
}
