
package org.blufin.sdk.response;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.blufin.base.helper.Pair;
import lombok.AccessLevel;
import lombok.Getter;
public class ApiResponsePagination {
    @Getter
    private final int page;
    @Getter
    private final int pageEntries;
    @Getter
    private final int totalPages;
    @Getter
    private final int totalEntries;
    @JsonProperty
    @Getter(AccessLevel.NONE)
    private final boolean hasMore;
    private ApiResponsePagination(int page, int entries, int totalRows) {
        Pair<Integer, Boolean> calculationResults = calculate(page, entries, totalRows);
        this.page = page;
        this.pageEntries = entries;
        this.totalPages = calculationResults.getKey();
        this.totalEntries = totalRows;
        this.hasMore = calculationResults.getValue();
    }
    public static ApiResponsePagination of(int page, int entries, int totalRows) {
        return new ApiResponsePagination(page, entries, totalRows);
    }
    public boolean hasMore() {
        return hasMore;
    }
    private Pair<Integer, Boolean> calculate(int page, int entries, int totalRows) {
        int pageRemainder = totalRows % entries;
        int pagesTotal = (totalRows / entries) + (pageRemainder > 0 ? 1 : 0);
        return Pair.of(pagesTotal, (page < pagesTotal));
    }
}
