
package org.blufin.sdk.rest;
import org.blufin.sdk.base.AbstractMetaData;
import org.blufin.sdk.enums.HttpMethod;
import org.blufin.sdk.response.AckResolver;
import lombok.Getter;
@Getter
public abstract class AbstractRequest {
    protected final HttpMethod httpMethod;
    protected final AbstractMetaData metaData;
    protected final AckResolver ackResolver;
    protected AbstractRequest(HttpMethod httpMethod, AbstractMetaData metaData) {
        this.httpMethod = httpMethod;
        this.metaData = metaData;
        this.ackResolver = new AckResolver();
    }
    protected AbstractRequest(HttpMethod httpMethod, AbstractMetaData metaData, AckResolver ackResolver) {
        this.httpMethod = httpMethod;
        this.metaData = metaData;
        this.ackResolver = ackResolver;
    }
}
