
package org.blufin.sdk.rest;
import lombok.Getter;
import org.blufin.base.exceptions.BlufinServerException;
import org.blufin.base.helper.IdSet;
import org.blufin.sdk.base.AbstractMetaData;
import org.blufin.sdk.base.AbstractValidatorInterface;
import org.blufin.sdk.enums.HttpMethod;
import java.sql.Connection;
@Getter
public class DeleteRequest extends AbstractRequest {
    private final IdSet ids;
    public DeleteRequest(Connection connection, AbstractMetaData metaData, AbstractValidatorInterface validator, IdSet ids) throws BlufinServerException {
        super(HttpMethod.DELETE, metaData);
        this.ids = ids;
        if (ids.getErrors().size() == 0 && this.ids.size() > 0) {
            validator.validateDelete(connection, this.ids, ackResolver);
        }
    }
}
