
package org.blufin.sdk.service;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.mashape.unirest.http.ObjectMapper;
import com.mashape.unirest.http.Unirest;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.blufin.sdk.base.ResourceData;
import org.blufin.sdk.service.credentials.ApiCredentials;
import javax.net.ssl.SSLContext;
import java.io.IOException;
import java.text.MessageFormat;
@Getter(AccessLevel.PROTECTED)
@Setter(AccessLevel.PROTECTED)
public abstract class BlufinApiService {
    private boolean initialized = false;
    private ResourceData resourceData;
    private ApiCredentials apiCredentials;
    public abstract void initialize(ResourceData resourceData);
    public abstract void initialize(String authorizationHeader, String apiUri);
    protected void initializeParent(ApiCredentials apiCredentials) {
        if (notInitialized()) {
            this.apiCredentials = apiCredentials;
        }
    }
    private boolean notInitialized() {
        if (initialized == true) {
            throw new RuntimeException(MessageFormat.format("Cannot initialize class twice: {0}", this.getClass().getSimpleName()));
        }
        initialized = true;
        return true;
    }
    static {
        Unirest.setObjectMapper(new ObjectMapper() {
            private com.fasterxml.jackson.databind.ObjectMapper objectMapper = new com.fasterxml.jackson.databind.ObjectMapper();
            @Override
            public <T> T readValue(String body, Class<T> clazz) {
                try {
                    return objectMapper.readValue(body, clazz);
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            @Override
            public String writeValue(Object object) {
                try {
                    return objectMapper.writeValueAsString(object);
                } catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        try {
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, new TrustSelfSignedStrategy()).build();
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, (s, sslSession) -> true);
            Unirest.setHttpClient(HttpClients.custom().setSSLSocketFactory(socketFactory).build());
        } catch (Exception e) {
            throw new RuntimeException("Failed to configure Unirest HTTP Client with custom SSLContext.", e);
        }
    }
}
