/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.sdk.base;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.blufin.base.enums.DataType;
import org.blufin.base.enums.SchemaType;
import org.blufin.base.exceptions.BlufinAlertDeveloperException;
import org.blufin.base.helper.Pair;
import org.blufin.sdk.base.MetaDataException;

public abstract class AbstractMetaData {
    public static final String DECIMAL_DISTRIBUTION = "decimal_distribution";
    public static final String DESCRIPTION = "description";
    public static final String ENCRYPTED = "encrypted";
    public static final String ENUM_NAME = "enum_name";
    public static final String ENUM_VALUES = "enum_values";
    public static final String FKEY = "fkey";
    public static final String FLAG = "flag";
    public static final String ID = "id";
    public static final String LINK = "link";
    public static final String MAX_LENGTH = "max_length";
    public static final String CHILD_OF = "child_of";
    public static final String REQUIRED = "required";
    public static final String REQUIRED_IF = "required_if";
    public static final String TYPE = "type";
    public static final String TRANSIENT = "transient";
    public static final String FLAG_AUTO_INCREMENT = "AUTO_INCREMENT";
    public static final String FLAG_INDEX = "INDEX";
    public static final String FLAG_NULLABLE = "NULLABLE";
    public static final String FLAG_PRIMARY_KEY = "PRIMARY_KEY";
    public static final String FLAG_UNIQUE = "UNIQUE";
    public static final List<DataType> CONTAINER_TYPES = Collections.unmodifiableList(Arrays.asList(DataType.OBJECT, DataType.OBJECT_LIST, DataType.OBJECT_LINK));
    protected final LinkedHashMap<String, HashMap<String, Object>> metaData = new LinkedHashMap();
    private final SchemaType schema;
    private final String table;
    private final String parentTable;
    private final List<String> tableHierarchy;
    private final DataType childType;

    protected AbstractMetaData(SchemaType schema, String table, String parentTable, List<String> tableHierarchy, DataType childType) {
        this.schema = schema;
        this.table = table;
        this.parentTable = parentTable;
        this.tableHierarchy = tableHierarchy;
        this.childType = childType;
    }

    public abstract AbstractMetaData getNestedMetaData(String var1);

    public boolean containsFieldExcludingObjects(String fieldName) {
        if (this.metaData.containsKey(fieldName)) {
            try {
                if (!(this.getType(fieldName).equals((Object)DataType.OBJECT) || this.getType(fieldName).equals((Object)DataType.OBJECT_LIST) || this.getType(fieldName).equals((Object)DataType.OBJECT_LINK))) {
                    return true;
                }
            }
            catch (MetaDataException e) {
                throw new BlufinAlertDeveloperException((Exception)e);
            }
        }
        return false;
    }

    public boolean containsField(String fieldName) {
        return this.metaData.containsKey(fieldName);
    }

    public List<String> getAllFields() {
        return this.getAllFields(false);
    }

    public List<String> getAllFieldsIncludingContainers() {
        return this.getAllFields(true);
    }

    public List<String> getRequiredFields() {
        return this.getRequiredFields(false);
    }

    public List<String> getRequiredFieldsIncludingContainers() {
        return this.getRequiredFields(true);
    }

    public Set<String> getAllNestedTables() {
        TreeSet<String> allNestedTables = new TreeSet<String>();
        this.tableHierarchy.forEach(table -> allNestedTables.add(table.replaceAll("/", "_")));
        return allNestedTables;
    }

    public DataType getType(String fieldName) throws MetaDataException {
        this.checkFieldExists(fieldName);
        return (DataType)this.metaData.get(fieldName).get(TYPE);
    }

    public Integer getMaxLength(String fieldName) throws MetaDataException {
        this.checkFieldExists(fieldName);
        if (this.metaData.get(fieldName).keySet().contains(MAX_LENGTH)) {
            return (Integer)this.metaData.get(fieldName).get(MAX_LENGTH);
        }
        return null;
    }

    public String getDescription(String fieldName) throws MetaDataException {
        this.checkFieldExists(fieldName);
        if (this.metaData.get(fieldName).keySet().contains(DESCRIPTION)) {
            return (String)this.metaData.get(fieldName).get(DESCRIPTION);
        }
        return null;
    }

    public Pair<Integer, Integer> getDecimalDistribution(String fieldName) throws MetaDataException {
        this.checkFieldAndKeyExists(fieldName, DECIMAL_DISTRIBUTION);
        return (Pair)this.metaData.get(fieldName).get(DECIMAL_DISTRIBUTION);
    }

    public String getEnumName(String fieldName) throws MetaDataException {
        this.checkFieldAndKeyExists(fieldName, ENUM_NAME);
        return (String)this.metaData.get(fieldName).get(ENUM_NAME);
    }

    public List<String> getEnumValues(String fieldName) throws MetaDataException {
        this.checkFieldAndKeyExists(fieldName, ENUM_VALUES);
        return (List)this.metaData.get(fieldName).get(ENUM_VALUES);
    }

    public String getForeignKey(String fieldName) throws MetaDataException {
        this.checkFieldAndKeyExists(fieldName, FKEY);
        return (String)this.metaData.get(fieldName).get(FKEY);
    }

    public String getLink(String fieldName) throws MetaDataException {
        this.checkFieldAndKeyExists(fieldName, LINK);
        return (String)this.metaData.get(fieldName).get(LINK);
    }

    public String getParentIdFieldName() {
        if (this.parentTable == null) {
            throw new BlufinAlertDeveloperException(MessageFormat.format("Table ''{0}'' does not have a parent, and therefore, {1}.getParentIdFieldName() should never be called.", this.table, AbstractMetaData.class.getSimpleName()));
        }
        return this.parentTable + "_" + ID;
    }

    public boolean isAutoIncrement(String fieldName) throws MetaDataException {
        return this.hasFlag(fieldName, FLAG_AUTO_INCREMENT);
    }

    public boolean isIndex(String fieldName) throws MetaDataException {
        return this.hasFlag(fieldName, FLAG_INDEX);
    }

    public boolean isNullAllowed(String fieldName) throws MetaDataException {
        return this.hasFlag(fieldName, FLAG_NULLABLE);
    }

    public boolean isPrimaryKey(String fieldName) throws MetaDataException {
        return this.hasFlag(fieldName, FLAG_PRIMARY_KEY);
    }

    public boolean isUnique(String fieldName) throws MetaDataException {
        return this.hasFlag(fieldName, FLAG_UNIQUE) || this.isAutoIncrement(fieldName);
    }

    public boolean isEncrypted(String fieldName) throws MetaDataException {
        return this.hasKey(fieldName, ENCRYPTED);
    }

    public boolean isRequired(String fieldName) throws MetaDataException {
        return this.hasKey(fieldName, REQUIRED);
    }

    public boolean isTransient(String fieldName) throws MetaDataException {
        return this.hasKey(fieldName, TRANSIENT);
    }

    public boolean isForeignKeyed(String fieldName) throws MetaDataException {
        return this.hasKey(fieldName, FKEY);
    }

    public boolean isForeignKeyedAsChild(String fieldName) throws MetaDataException {
        return this.hasKey(fieldName, CHILD_OF);
    }

    public boolean isLinked(String fieldName) throws MetaDataException {
        return this.hasKey(fieldName, LINK);
    }

    public boolean isObject(String fieldName) throws MetaDataException {
        return this.getType(fieldName).equals((Object)DataType.OBJECT);
    }

    public boolean isObjectMap(String fieldName) throws MetaDataException {
        return this.getType(fieldName).equals((Object)DataType.OBJECT_LIST);
    }

    public boolean isNestedObject() {
        return this.childType != null && this.childType.equals((Object)DataType.OBJECT);
    }

    public boolean isNestedObjectList() {
        return this.childType != null && this.childType.equals((Object)DataType.OBJECT_LIST);
    }

    protected List<String> getEnumValues(Enum[] values) {
        ArrayList<String> valueList = new ArrayList<String>();
        for (Enum value : values) {
            valueList.add(value.toString());
        }
        return valueList;
    }

    private boolean hasKey(String fieldName, String key) throws MetaDataException {
        this.checkFieldExists(fieldName);
        return this.metaData.get(fieldName).keySet().contains(key);
    }

    private boolean hasFlag(String fieldName, String key) throws MetaDataException {
        this.checkFieldExists(fieldName);
        if (this.metaData.get(fieldName).keySet().contains(FLAG)) {
            List flags = (List)this.metaData.get(fieldName).get(FLAG);
            return flags.contains(key);
        }
        return false;
    }

    private void checkFieldExists(String fieldName) throws MetaDataException {
        if (!this.metaData.containsKey(fieldName)) {
            throw new MetaDataException(MessageFormat.format("Field not found: {0}", fieldName));
        }
    }

    private void checkFieldAndKeyExists(String fieldName, String key) throws MetaDataException {
        this.checkFieldExists(fieldName);
        if (!this.metaData.get(fieldName).keySet().contains(key)) {
            throw new MetaDataException(MessageFormat.format("Field ''{0}'' does not have key \u2192 {1}", fieldName, key));
        }
    }

    private List<String> getAllFields(boolean includeContainers) {
        ArrayList<String> allFields = new ArrayList<String>();
        this.metaData.keySet().stream().forEach(fieldName -> {
            try {
                if (includeContainers || !this.getType((String)fieldName).equals((Object)DataType.OBJECT) && !this.getType((String)fieldName).equals((Object)DataType.OBJECT_LIST) && !this.getType((String)fieldName).equals((Object)DataType.OBJECT_LINK)) {
                    allFields.add((String)fieldName);
                }
            }
            catch (MetaDataException e) {
                throw new BlufinAlertDeveloperException((Exception)e);
            }
        });
        return allFields;
    }

    private List<String> getRequiredFields(boolean includeContainers) {
        ArrayList<String> requiredFields = new ArrayList<String>();
        this.metaData.keySet().stream().forEach(fieldName -> {
            try {
                if (this.getType((String)fieldName).equals((Object)DataType.OBJECT_LIST) && !includeContainers) {
                    return;
                }
                if (!(!this.getType((String)fieldName).equals((Object)DataType.OBJECT_LINK) && !this.getType((String)fieldName).equals((Object)DataType.OBJECT) || includeContainers && this.isRequired((String)fieldName))) {
                    return;
                }
                if (fieldName.equals(ID) || this.isNullAllowed((String)fieldName) || this.isTransient((String)fieldName) || this.isForeignKeyedAsChild((String)fieldName)) {
                    return;
                }
                requiredFields.add((String)fieldName);
            }
            catch (MetaDataException e) {
                throw new BlufinAlertDeveloperException((Exception)e);
            }
        });
        return requiredFields;
    }

    public SchemaType getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public String getParentTable() {
        return this.parentTable;
    }

    public List<String> getTableHierarchy() {
        return this.tableHierarchy;
    }

    public DataType getChildType() {
        return this.childType;
    }
}

