/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.sdk.filters;

import java.util.HashMap;
import java.util.Map;

public enum Modifier {
    EQUALS("="),
    NOT_EQUALS("!="),
    GREATER(">"),
    GREATER_OR_EQUAL(">="),
    LESS("<"),
    LESS_OR_EQUAL("<="),
    BETWEEN("><"),
    BETWEEN_OR_EQUAL("=><="),
    CONTAINS("%"),
    NOT_CONTAINS("!%"),
    STARTS_WITH("^%"),
    NOT_STARTS_WITH("!^%"),
    ENDS_WITH("%^"),
    NOT_ENDS_WITH("!%^");

    private static Map<String, Modifier> map;
    private final String symbol;

    private Modifier(String symbol) {
        this.symbol = symbol;
    }

    public static final Modifier get(String symbol) {
        return map.get(symbol);
    }

    public String toString() {
        return this.symbol;
    }

    public String getSymbol() {
        return this.symbol;
    }

    static {
        map = new HashMap<String, Modifier>();
        for (Modifier modifier : Modifier.values()) {
            map.put(modifier.getSymbol(), modifier);
        }
    }
}

