/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.sdk.filters.dynamic;

import java.util.List;
import org.blufin.sdk.base.AbstractFilter;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.FilterType;

public abstract class FilterBase<T> {
    private Filter filter;
    private T originalRequest;

    protected FilterBase(FilterType filterType, AbstractFilter filter, List<Filter> filters, T originalRequest, boolean allowDuplicates) {
        this.filter = new Filter(filterType, filter.getFieldName());
        this.originalRequest = originalRequest;
        if (!allowDuplicates && this.alreadyExists(filter, filters)) {
            return;
        }
        filters.add(this.filter);
    }

    private boolean alreadyExists(AbstractFilter filter, List<Filter> filters) {
        for (Filter filterObject : filters) {
            if (!filterObject.getFieldName().equals(filter.getFieldName())) continue;
            return true;
        }
        return false;
    }

    protected Filter getFilter() {
        return this.filter;
    }

    protected T getOriginalRequest() {
        return this.originalRequest;
    }
}

