/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.sdk.filters.dynamic;

import java.time.LocalDate;
import java.util.List;
import org.blufin.base.utils.UtilsDate;
import org.blufin.sdk.base.AbstractFilter;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.FilterType;
import org.blufin.sdk.filters.Modifier;
import org.blufin.sdk.filters.dynamic.FilterBase;
import org.blufin.sdk.filters.interfaces.MatchComparisonFilterable;

public class FilterDate<T>
extends FilterBase<T>
implements MatchComparisonFilterable<T, LocalDate> {
    public FilterDate(AbstractFilter filter, List<Filter> filters, T originalRequest) {
        super(FilterType.DATE, filter, filters, originalRequest, true);
    }

    @Override
    public T is(LocalDate value) {
        this.getFilter().setModifier(Modifier.EQUALS);
        this.getFilter().setPrimaryValue(UtilsDate.convertLocalDateToString((LocalDate)value));
        return this.getOriginalRequest();
    }

    @Override
    public T isNot(LocalDate value) {
        this.getFilter().setModifier(Modifier.NOT_EQUALS);
        this.getFilter().setPrimaryValue(UtilsDate.convertLocalDateToString((LocalDate)value));
        return this.getOriginalRequest();
    }

    @Override
    public T isLessThan(LocalDate value) {
        this.getFilter().setModifier(Modifier.LESS);
        this.getFilter().setPrimaryValue(UtilsDate.convertLocalDateToString((LocalDate)value));
        return this.getOriginalRequest();
    }

    @Override
    public T isLessThanOrEqualTo(LocalDate value) {
        this.getFilter().setModifier(Modifier.LESS_OR_EQUAL);
        this.getFilter().setPrimaryValue(UtilsDate.convertLocalDateToString((LocalDate)value));
        return this.getOriginalRequest();
    }

    @Override
    public T isGreaterThan(LocalDate value) {
        this.getFilter().setModifier(Modifier.GREATER);
        this.getFilter().setPrimaryValue(UtilsDate.convertLocalDateToString((LocalDate)value));
        return this.getOriginalRequest();
    }

    @Override
    public T isGreaterThanOrEqualTo(LocalDate value) {
        this.getFilter().setModifier(Modifier.GREATER_OR_EQUAL);
        this.getFilter().setPrimaryValue(UtilsDate.convertLocalDateToString((LocalDate)value));
        return this.getOriginalRequest();
    }

    @Override
    public T isBetween(LocalDate from, LocalDate to) {
        LocalDate[] localDates = this.earliestToLatest(from, to);
        this.getFilter().setModifier(Modifier.BETWEEN);
        this.getFilter().setPrimaryValue(UtilsDate.convertLocalDateToString((LocalDate)localDates[0]));
        this.getFilter().setSecondaryValue(UtilsDate.convertLocalDateToString((LocalDate)localDates[1]));
        return this.getOriginalRequest();
    }

    @Override
    public T isBetweenOrEqualTo(LocalDate from, LocalDate to) {
        LocalDate[] localDates = this.earliestToLatest(from, to);
        this.getFilter().setModifier(Modifier.BETWEEN_OR_EQUAL);
        this.getFilter().setPrimaryValue(UtilsDate.convertLocalDateToString((LocalDate)localDates[0]));
        this.getFilter().setSecondaryValue(UtilsDate.convertLocalDateToString((LocalDate)localDates[1]));
        return this.getOriginalRequest();
    }

    private LocalDate[] earliestToLatest(LocalDate from, LocalDate to) {
        LocalDate[] localDates = new LocalDate[]{from.isBefore(to) ? from : to, from.isBefore(to) ? to : from};
        return localDates;
    }
}

