/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.sdk.filters.dynamic;

import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.blufin.base.utils.UtilsDate;
import org.blufin.sdk.base.AbstractFilter;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.FilterType;
import org.blufin.sdk.filters.Modifier;
import org.blufin.sdk.filters.dynamic.FilterBase;
import org.blufin.sdk.filters.interfaces.MatchComparisonFilterable;

public class FilterDateTime<T>
extends FilterBase<T>
implements MatchComparisonFilterable<T, ZonedDateTime> {
    public FilterDateTime(AbstractFilter filter, List<Filter> filters, T originalRequest) {
        super(FilterType.DATETIME, filter, filters, originalRequest, true);
    }

    @Override
    public T is(ZonedDateTime value) {
        this.getFilter().setModifier(Modifier.EQUALS);
        this.getFilter().setPrimaryValue(UtilsDate.convertZonedDateTimeToString((ZonedDateTime)value));
        return this.getOriginalRequest();
    }

    @Override
    public T isNot(ZonedDateTime value) {
        this.getFilter().setModifier(Modifier.NOT_EQUALS);
        this.getFilter().setPrimaryValue(UtilsDate.convertZonedDateTimeToString((ZonedDateTime)value));
        return this.getOriginalRequest();
    }

    @Override
    public T isLessThan(ZonedDateTime value) {
        this.getFilter().setModifier(Modifier.LESS);
        this.getFilter().setPrimaryValue(UtilsDate.convertZonedDateTimeToString((ZonedDateTime)value));
        return this.getOriginalRequest();
    }

    @Override
    public T isLessThanOrEqualTo(ZonedDateTime value) {
        this.getFilter().setModifier(Modifier.LESS_OR_EQUAL);
        this.getFilter().setPrimaryValue(UtilsDate.convertZonedDateTimeToString((ZonedDateTime)value));
        return this.getOriginalRequest();
    }

    @Override
    public T isGreaterThan(ZonedDateTime value) {
        this.getFilter().setModifier(Modifier.GREATER);
        this.getFilter().setPrimaryValue(UtilsDate.convertZonedDateTimeToString((ZonedDateTime)value));
        return this.getOriginalRequest();
    }

    @Override
    public T isGreaterThanOrEqualTo(ZonedDateTime value) {
        this.getFilter().setModifier(Modifier.GREATER_OR_EQUAL);
        this.getFilter().setPrimaryValue(UtilsDate.convertZonedDateTimeToString((ZonedDateTime)value));
        return this.getOriginalRequest();
    }

    @Override
    public T isBetween(ZonedDateTime from, ZonedDateTime to) {
        ZonedDateTime[] zonedDateTimes = this.earliestToLatest(from, to);
        this.getFilter().setModifier(Modifier.BETWEEN);
        this.getFilter().setPrimaryValue(UtilsDate.convertZonedDateTimeToString((ZonedDateTime)zonedDateTimes[0]));
        this.getFilter().setSecondaryValue(UtilsDate.convertZonedDateTimeToString((ZonedDateTime)zonedDateTimes[1]));
        return this.getOriginalRequest();
    }

    @Override
    public T isBetweenOrEqualTo(ZonedDateTime from, ZonedDateTime to) {
        ZonedDateTime[] zonedDateTimes = this.earliestToLatest(from, to);
        this.getFilter().setModifier(Modifier.BETWEEN_OR_EQUAL);
        this.getFilter().setPrimaryValue(UtilsDate.convertZonedDateTimeToString((ZonedDateTime)zonedDateTimes[0]));
        this.getFilter().setSecondaryValue(UtilsDate.convertZonedDateTimeToString((ZonedDateTime)zonedDateTimes[1]));
        return this.getOriginalRequest();
    }

    private ZonedDateTime[] earliestToLatest(ZonedDateTime from, ZonedDateTime to) {
        ZonedDateTime[] zoneDateTimes = new ZonedDateTime[]{ChronoUnit.MINUTES.between(from, to) >= 0L ? from : to, ChronoUnit.MINUTES.between(from, to) >= 0L ? to : from};
        return zoneDateTimes;
    }
}

