/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.sdk.filters.dynamic;

import java.math.BigDecimal;
import java.util.List;
import org.blufin.sdk.base.AbstractFilter;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.FilterType;
import org.blufin.sdk.filters.Modifier;
import org.blufin.sdk.filters.dynamic.FilterBase;
import org.blufin.sdk.filters.interfaces.DecimalFilterable;

public class FilterDecimal<T>
extends FilterBase<T>
implements DecimalFilterable<T> {
    public FilterDecimal(AbstractFilter filter, List<Filter> filters, T originalRequest) {
        super(FilterType.DECIMAL, filter, filters, originalRequest, true);
    }

    @Override
    public T is(BigDecimal value) {
        this.getFilter().setModifier(Modifier.EQUALS);
        this.getFilter().setPrimaryValue(value.toString());
        return this.getOriginalRequest();
    }

    @Override
    public T isNot(BigDecimal value) {
        this.getFilter().setModifier(Modifier.NOT_EQUALS);
        this.getFilter().setPrimaryValue(value.toString());
        return this.getOriginalRequest();
    }

    @Override
    public T isLessThan(BigDecimal value) {
        this.getFilter().setModifier(Modifier.LESS);
        this.getFilter().setPrimaryValue(value.toString());
        return this.getOriginalRequest();
    }

    @Override
    public T isLessThanOrEqualTo(BigDecimal value) {
        this.getFilter().setModifier(Modifier.LESS_OR_EQUAL);
        this.getFilter().setPrimaryValue(value.toString());
        return this.getOriginalRequest();
    }

    @Override
    public T isGreaterThan(BigDecimal value) {
        this.getFilter().setModifier(Modifier.GREATER);
        this.getFilter().setPrimaryValue(value.toString());
        return this.getOriginalRequest();
    }

    @Override
    public T isGreaterThanOrEqualTo(BigDecimal value) {
        this.getFilter().setModifier(Modifier.GREATER_OR_EQUAL);
        this.getFilter().setPrimaryValue(value.toString());
        return this.getOriginalRequest();
    }

    @Override
    public T isBetween(BigDecimal from, BigDecimal to) {
        BigDecimal[] values = this.smallestToHighest(from, to);
        this.getFilter().setModifier(Modifier.BETWEEN);
        this.getFilter().setPrimaryValue(String.valueOf(values[0]));
        this.getFilter().setSecondaryValue(String.valueOf(values[1]));
        return this.getOriginalRequest();
    }

    @Override
    public T isBetweenOrEqualTo(BigDecimal from, BigDecimal to) {
        BigDecimal[] values = this.smallestToHighest(from, to);
        this.getFilter().setModifier(Modifier.BETWEEN_OR_EQUAL);
        this.getFilter().setPrimaryValue(String.valueOf(values[0]));
        this.getFilter().setSecondaryValue(String.valueOf(values[1]));
        return this.getOriginalRequest();
    }

    private BigDecimal[] smallestToHighest(BigDecimal from, BigDecimal to) {
        BigDecimal[] values = new BigDecimal[]{from.compareTo(to) == -1 || from.compareTo(to) == 0 ? from : to, from.compareTo(to) == -1 || from.compareTo(to) == 0 ? to : from};
        return values;
    }
}

