/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.sdk.filters.dynamic;

import java.util.List;
import org.blufin.sdk.base.AbstractFilter;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.FilterType;
import org.blufin.sdk.filters.Modifier;
import org.blufin.sdk.filters.dynamic.FilterBase;
import org.blufin.sdk.filters.interfaces.IntegerFilterable;

public class FilterInteger<T>
extends FilterBase<T>
implements IntegerFilterable<T> {
    public FilterInteger(AbstractFilter filter, List<Filter> filters, T originalRequest) {
        super(FilterType.INTEGER, filter, filters, originalRequest, true);
    }

    @Override
    public T is(int value) {
        this.getFilter().setModifier(Modifier.EQUALS);
        this.getFilter().setPrimaryValue(String.valueOf(value));
        return this.getOriginalRequest();
    }

    @Override
    public T isNot(int value) {
        this.getFilter().setModifier(Modifier.NOT_EQUALS);
        this.getFilter().setPrimaryValue(String.valueOf(value));
        return this.getOriginalRequest();
    }

    @Override
    public T isLessThan(int value) {
        this.getFilter().setModifier(Modifier.LESS);
        this.getFilter().setPrimaryValue(String.valueOf(value));
        return this.getOriginalRequest();
    }

    @Override
    public T isLessThanOrEqualTo(int value) {
        this.getFilter().setModifier(Modifier.LESS_OR_EQUAL);
        this.getFilter().setPrimaryValue(String.valueOf(value));
        return this.getOriginalRequest();
    }

    @Override
    public T isGreaterThan(int value) {
        this.getFilter().setModifier(Modifier.GREATER);
        this.getFilter().setPrimaryValue(String.valueOf(value));
        return this.getOriginalRequest();
    }

    @Override
    public T isGreaterThanOrEqualTo(int value) {
        this.getFilter().setModifier(Modifier.GREATER_OR_EQUAL);
        this.getFilter().setPrimaryValue(String.valueOf(value));
        return this.getOriginalRequest();
    }

    @Override
    public T isBetween(int from, int to) {
        int[] values = this.smallestToHighest(from, to);
        this.getFilter().setModifier(Modifier.BETWEEN);
        this.getFilter().setPrimaryValue(String.valueOf(values[0]));
        this.getFilter().setSecondaryValue(String.valueOf(values[1]));
        return this.getOriginalRequest();
    }

    @Override
    public T isBetweenOrEqualTo(int from, int to) {
        int[] values = this.smallestToHighest(from, to);
        this.getFilter().setModifier(Modifier.BETWEEN_OR_EQUAL);
        this.getFilter().setPrimaryValue(String.valueOf(values[0]));
        this.getFilter().setSecondaryValue(String.valueOf(values[1]));
        return this.getOriginalRequest();
    }

    private int[] smallestToHighest(int from, int to) {
        int[] values = new int[]{from <= to ? from : to, from <= to ? to : from};
        return values;
    }
}

