/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.sdk.filters.dynamic;

import java.util.List;
import org.blufin.sdk.base.AbstractFilter;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.FilterType;
import org.blufin.sdk.filters.Modifier;
import org.blufin.sdk.filters.dynamic.FilterBase;
import org.blufin.sdk.filters.interfaces.IntegerBigFilterable;

public class FilterIntegerBig<T>
extends FilterBase<T>
implements IntegerBigFilterable<T> {
    public FilterIntegerBig(AbstractFilter filter, List<Filter> filters, T originalRequest) {
        super(FilterType.INTEGER_BIG, filter, filters, originalRequest, true);
    }

    @Override
    public T is(long value) {
        this.getFilter().setModifier(Modifier.EQUALS);
        this.getFilter().setPrimaryValue(String.valueOf(value));
        return this.getOriginalRequest();
    }

    @Override
    public T isNot(long value) {
        this.getFilter().setModifier(Modifier.NOT_EQUALS);
        this.getFilter().setPrimaryValue(String.valueOf(value));
        return this.getOriginalRequest();
    }

    @Override
    public T isLessThan(long value) {
        this.getFilter().setModifier(Modifier.LESS);
        this.getFilter().setPrimaryValue(String.valueOf(value));
        return this.getOriginalRequest();
    }

    @Override
    public T isLessThanOrEqualTo(long value) {
        this.getFilter().setModifier(Modifier.LESS_OR_EQUAL);
        this.getFilter().setPrimaryValue(String.valueOf(value));
        return this.getOriginalRequest();
    }

    @Override
    public T isGreaterThan(long value) {
        this.getFilter().setModifier(Modifier.GREATER);
        this.getFilter().setPrimaryValue(String.valueOf(value));
        return this.getOriginalRequest();
    }

    @Override
    public T isGreaterThanOrEqualTo(long value) {
        this.getFilter().setModifier(Modifier.GREATER_OR_EQUAL);
        this.getFilter().setPrimaryValue(String.valueOf(value));
        return this.getOriginalRequest();
    }

    @Override
    public T isBetween(long from, long to) {
        long[] values = this.smallestToHighest(from, to);
        this.getFilter().setModifier(Modifier.BETWEEN);
        this.getFilter().setPrimaryValue(String.valueOf(values[0]));
        this.getFilter().setSecondaryValue(String.valueOf(values[1]));
        return this.getOriginalRequest();
    }

    @Override
    public T isBetweenOrEqualTo(long from, long to) {
        long[] values = this.smallestToHighest(from, to);
        this.getFilter().setModifier(Modifier.BETWEEN_OR_EQUAL);
        this.getFilter().setPrimaryValue(String.valueOf(values[0]));
        this.getFilter().setSecondaryValue(String.valueOf(values[1]));
        return this.getOriginalRequest();
    }

    private long[] smallestToHighest(long from, long to) {
        long[] values = new long[]{from <= to ? from : to, from <= to ? to : from};
        return values;
    }
}

