/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.sdk.filters.dynamic;

import java.util.List;
import org.blufin.sdk.base.AbstractFilter;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.FilterType;
import org.blufin.sdk.filters.Modifier;
import org.blufin.sdk.filters.dynamic.FilterBase;
import org.blufin.sdk.filters.interfaces.IntegerSmallFilterable;

public class FilterIntegerSmall<T>
extends FilterBase<T>
implements IntegerSmallFilterable<T> {
    public FilterIntegerSmall(AbstractFilter filter, List<Filter> filters, T originalRequest) {
        super(FilterType.INTEGER_SMALL, filter, filters, originalRequest, true);
    }

    @Override
    public T is(short value) {
        this.getFilter().setModifier(Modifier.EQUALS);
        this.getFilter().setPrimaryValue(String.valueOf(value));
        return this.getOriginalRequest();
    }

    @Override
    public T isNot(short value) {
        this.getFilter().setModifier(Modifier.NOT_EQUALS);
        this.getFilter().setPrimaryValue(String.valueOf(value));
        return this.getOriginalRequest();
    }

    @Override
    public T isLessThan(short value) {
        this.getFilter().setModifier(Modifier.LESS);
        this.getFilter().setPrimaryValue(String.valueOf(value));
        return this.getOriginalRequest();
    }

    @Override
    public T isLessThanOrEqualTo(short value) {
        this.getFilter().setModifier(Modifier.LESS_OR_EQUAL);
        this.getFilter().setPrimaryValue(String.valueOf(value));
        return this.getOriginalRequest();
    }

    @Override
    public T isGreaterThan(short value) {
        this.getFilter().setModifier(Modifier.GREATER);
        this.getFilter().setPrimaryValue(String.valueOf(value));
        return this.getOriginalRequest();
    }

    @Override
    public T isGreaterThanOrEqualTo(short value) {
        this.getFilter().setModifier(Modifier.GREATER_OR_EQUAL);
        this.getFilter().setPrimaryValue(String.valueOf(value));
        return this.getOriginalRequest();
    }

    @Override
    public T isBetween(short from, short to) {
        short[] values = this.smallestToHighest(from, to);
        this.getFilter().setModifier(Modifier.BETWEEN);
        this.getFilter().setPrimaryValue(String.valueOf(values[0]));
        this.getFilter().setSecondaryValue(String.valueOf(values[1]));
        return this.getOriginalRequest();
    }

    @Override
    public T isBetweenOrEqualTo(short from, short to) {
        short[] values = this.smallestToHighest(from, to);
        this.getFilter().setModifier(Modifier.BETWEEN_OR_EQUAL);
        this.getFilter().setPrimaryValue(String.valueOf(values[0]));
        this.getFilter().setSecondaryValue(String.valueOf(values[1]));
        return this.getOriginalRequest();
    }

    private short[] smallestToHighest(short from, short to) {
        short[] values = new short[]{from <= to ? from : to, from <= to ? to : from};
        return values;
    }
}

