/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.sdk.filters.dynamic;

import java.util.List;
import org.blufin.sdk.base.AbstractFilter;
import org.blufin.sdk.filters.Filter;
import org.blufin.sdk.filters.FilterType;
import org.blufin.sdk.filters.Modifier;
import org.blufin.sdk.filters.dynamic.FilterBase;
import org.blufin.sdk.filters.interfaces.IntegerTinyFilterable;

public class FilterIntegerTiny<T>
extends FilterBase<T>
implements IntegerTinyFilterable<T> {
    public FilterIntegerTiny(AbstractFilter filter, List<Filter> filters, T originalRequest) {
        super(FilterType.INTEGER_TINY, filter, filters, originalRequest, true);
    }

    @Override
    public T is(byte value) {
        this.getFilter().setModifier(Modifier.EQUALS);
        this.getFilter().setPrimaryValue(String.valueOf(value));
        return this.getOriginalRequest();
    }

    @Override
    public T isNot(byte value) {
        this.getFilter().setModifier(Modifier.NOT_EQUALS);
        this.getFilter().setPrimaryValue(String.valueOf(value));
        return this.getOriginalRequest();
    }

    @Override
    public T isLessThan(byte value) {
        this.getFilter().setModifier(Modifier.LESS);
        this.getFilter().setPrimaryValue(String.valueOf(value));
        return this.getOriginalRequest();
    }

    @Override
    public T isLessThanOrEqualTo(byte value) {
        this.getFilter().setModifier(Modifier.LESS_OR_EQUAL);
        this.getFilter().setPrimaryValue(String.valueOf(value));
        return this.getOriginalRequest();
    }

    @Override
    public T isGreaterThan(byte value) {
        this.getFilter().setModifier(Modifier.GREATER);
        this.getFilter().setPrimaryValue(String.valueOf(value));
        return this.getOriginalRequest();
    }

    @Override
    public T isGreaterThanOrEqualTo(byte value) {
        this.getFilter().setModifier(Modifier.GREATER_OR_EQUAL);
        this.getFilter().setPrimaryValue(String.valueOf(value));
        return this.getOriginalRequest();
    }

    @Override
    public T isBetween(byte from, byte to) {
        byte[] values = this.smallestToHighest(from, to);
        this.getFilter().setModifier(Modifier.BETWEEN);
        this.getFilter().setPrimaryValue(String.valueOf(values[0]));
        this.getFilter().setSecondaryValue(String.valueOf(values[1]));
        return this.getOriginalRequest();
    }

    @Override
    public T isBetweenOrEqualTo(byte from, byte to) {
        byte[] values = this.smallestToHighest(from, to);
        this.getFilter().setModifier(Modifier.BETWEEN_OR_EQUAL);
        this.getFilter().setPrimaryValue(String.valueOf(values[0]));
        this.getFilter().setSecondaryValue(String.valueOf(values[1]));
        return this.getOriginalRequest();
    }

    private byte[] smallestToHighest(byte from, byte to) {
        byte[] values = new byte[]{from <= to ? from : to, from <= to ? to : from};
        return values;
    }
}

