/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.sdk.helper;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.blufin.base.exceptions.BlufinAlertDeveloperException;
import org.blufin.sdk.base.PersistentDto;

public final class IdHelper {
    public static final <T> Set<T> findMissing(List<T> a, List<T> b) {
        return IdHelper.findMissing(new HashSet<T>(a), new HashSet<T>(b));
    }

    public static final <T> Set<T> findMissing(Set<T> a, Set<T> b) {
        HashSet<T> c = new HashSet<T>(a);
        c.removeAll(b);
        c.removeAll(Collections.singleton(null));
        return c;
    }

    public static final boolean isValid(Integer id) {
        return id != null && id > 0;
    }

    public static final Set<Integer> extractIds(List<? extends PersistentDto> dtos) {
        HashSet<Integer> ids = new HashSet<Integer>();
        dtos.forEach(dto -> {
            if (IdHelper.isValid(dto.getId())) {
                ids.add(dto.getId());
            }
        });
        return ids;
    }

    public static final Integer extractParentId(List<? extends PersistentDto> dtos) {
        HashSet ids = new HashSet();
        dtos.forEach(dto -> {
            if (IdHelper.isValid(dto.getParentId())) {
                ids.add(dto.getParentId());
            }
        });
        if (ids.size() == 0) {
            return null;
        }
        if (ids.size() == 1) {
            return (Integer)ids.iterator().next();
        }
        throw new BlufinAlertDeveloperException(MessageFormat.format("{0}.extractParentId() resolved more than 1 ID: {1}", IdHelper.class.getSimpleName(), ((Object)ids).toString()));
    }

    public static final void addParentId(List<? extends PersistentDto> dtos, int parentId) {
        if (parentId <= 0) {
            return;
        }
        dtos.forEach(dto -> {
            if (dto.getParentId() == null) {
                dto.setParentId(parentId);
            }
        });
    }

    public static final void addParentId(PersistentDto dto, int parentId) {
        if (parentId <= 0) {
            return;
        }
        if (dto.getParentId() == null) {
            dto.setParentId(parentId);
        }
    }
}

