/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.sdk.normalization;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.blufin.base.enums.TimeZone;
import org.blufin.base.helper.Triplet;
import org.blufin.base.utils.UtilsRegex;
import org.blufin.sdk.normalization.DataNormalizationException;
import org.blufin.sdk.response.AckError;
import org.blufin.sdk.response.AckResolver;

public class DateTimeSplitter {
    private static final Pattern REGEX_TIME = Pattern.compile("^([0-9]|0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]");
    private static final Pattern REGEX_MILLISECONDS = Pattern.compile("^\\.{1}\\d{1,9}");
    private static final Pattern REGEX_TIMEZONE = Pattern.compile("^(((\\+|-)(0[0-9]|1[0-9]|2[0-3]):[0-5][0-9])|Z)?(\\[[^\\[\\]\\s]+\\])?$");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Triplet<String, String, String> splitTimeNanoAndZone(String value, String element, AckResolver ackResolver) throws DataNormalizationException {
        String m = null;
        String z = null;
        if ((value = value.trim()).equals("")) {
            return Triplet.of(null, null, null);
        }
        if (!UtilsRegex.stringMatchesRegex((String)value, (Pattern)REGEX_TIME)) throw new DataNormalizationException();
        String t = value.substring(0, 8);
        Matcher msMatcher = REGEX_MILLISECONDS.matcher(value = value.substring(8));
        if (msMatcher.find()) {
            m = msMatcher.group(0).substring(1);
            value = value.substring(m.length() + 1);
        }
        if (value.trim().equals("")) return Triplet.of((Object)t, (Object)m, z);
        if (value.toUpperCase().equals(TimeZone.UTC.getZoneIdDisplay())) {
            z = TimeZone.UTC.getZoneIdDisplay();
            return Triplet.of((Object)t, (Object)m, z);
        } else if (UtilsRegex.stringMatchesRegex((String)value, (Pattern)REGEX_TIMEZONE)) {
            z = value;
            if (!value.substring(0, 1).equals("[") || !value.substring(z.length() - 1).equals("]")) return Triplet.of((Object)t, (Object)m, z);
            z = TimeZone.UTC.getZoneIdDisplay() + z;
            return Triplet.of((Object)t, (Object)m, z);
        } else {
            ackResolver.addError(AckError.DATETIME_INVALID_TIMEZONE, value, element);
            throw new DataNormalizationException();
        }
    }
}

