/*
 * Decompiled with CFR 0.152.
 */
package org.blufin.sdk.normalization;

import java.math.BigDecimal;
import org.blufin.base.helper.Pair;

public class DecimalHelper {
    public static BigDecimal getMinimumAllowedValue(Pair decimalDistribution) {
        int d;
        int m = (Integer)decimalDistribution.getKey();
        if (m < (d = ((Integer)decimalDistribution.getValue()).intValue())) {
            throw new IllegalArgumentException("When calculating minimum allowed Decimal value, m (" + m + ") cannot be smaller than d (" + d + ").");
        }
        BigDecimal zero = new BigDecimal(0);
        BigDecimal maximumAllowedValue = DecimalHelper.getMaximumAllowedValue(decimalDistribution);
        return zero.subtract(maximumAllowedValue);
    }

    public static BigDecimal getMaximumAllowedValue(Pair decimalDistribution) {
        int d;
        int m = (Integer)decimalDistribution.getKey();
        if (m < (d = ((Integer)decimalDistribution.getValue()).intValue())) {
            throw new IllegalArgumentException("When calculating maximum allowed Decimal value, m (" + m + ") cannot be smaller than d (" + d + ").");
        }
        String decimal = new String(new char[m]).replace("\u0000", "9");
        decimal = decimal.substring(0, m - d) + "." + decimal.substring(m - d);
        return new BigDecimal(decimal);
    }
}

